<?php
namespace App\Config;

class Custom
{
    public static function featureDashboardCapaian(): bool
    {
        return filter_var(env('FEATURE_DASHBOARD_CAPAIAN', 'false'), FILTER_VALIDATE_BOOLEAN);
    }

    public static function uploadPath(): string
    {
        return rtrim(env('UPLOAD_PATH', WRITEPATH . 'uploads'), '/');
    }

    public static function uploadMaxSize(): int
    {
        return (int) env('UPLOAD_MAX_SIZE', 10485760); // 10 MB default
    }

    public static function allowedExt(): array
    {
        $raw = env('ALLOWED_EXT', 'pdf,jpg,jpeg,png,zip');
        return array_filter(array_map('trim', explode(',', (string) $raw)));
    }
}
