<?php
namespace App\Controllers;

class ApiController extends BaseController
{
    // Return JSON trend (counts per day) from dokumentasi filtered by session levels
    public function userTrend()
    {
        $session = session();
        $level1Id = (int) ($session->get('level1') ?? 0);
        $level2Id = (int) ($session->get('level2') ?? 0);
        $level3Id = (int) ($session->get('level3') ?? 0);

        $points = [];
        try {
            $db = db_connect();
            $fields = $db->getFieldNames('dokumentasi');
            $builder = $db->table('dokumentasi');
            if ($level1Id && in_array('level1_id', $fields, true)) $builder->where('level1_id', $level1Id);
            if ($level2Id && in_array('level2_id', $fields, true)) $builder->where('level2_id', $level2Id);
            if ($level3Id && in_array('level3_id', $fields, true)) $builder->where('level3_id', $level3Id);

            // Date field detection
            $dateExpr = null;
            if (in_array('created_at', $fields, true)) {
                $dateExpr = 'DATE(created_at)';
            } elseif (in_array('tanggal', $fields, true)) {
                $dateExpr = 'DATE(tanggal)';
            } else {
                // fallback: group by id as day bucket (not ideal)
                $dateExpr = 'DATE(NOW())';
            }

            $builder->select("$dateExpr as d, COUNT(*) as c")
                    ->groupBy('d')
                    ->orderBy('d', 'ASC')
                    ->limit(30);

            foreach ($builder->get()->getResultArray() as $row) {
                $points[] = [
                    'date' => (string) ($row['d'] ?? date('Y-m-d')),
                    'count' => (int) ($row['c'] ?? 0),
                ];
            }
        } catch (\Throwable $e) {
            $points = [];
        }

        return $this->response->setJSON([ 'points' => $points ]);
    }

    // Diagnostics: reveal detected tables/columns and sample data for debugging schema
    public function userDiag()
    {
        $session = session();
        $level1Id = (int) ($session->get('level1') ?? 0);
        $level2Id = (int) ($session->get('level2') ?? 0);
        $level3Id = (int) ($session->get('level3') ?? 0);

        $diag = [
            'levels' => compact('level1Id','level2Id','level3Id'),
            'sources' => [],
        ];
        $candidates = ['dashboard_user','dokumentasi','dokumen','laporan','rencana','bidang'];
        try {
            $db = db_connect();
            foreach ($candidates as $tbl) {
                try {
                    $fields = $db->getFieldNames($tbl);
                    $info = [ 'table' => $tbl, 'fields' => $fields ];
                    // sample
                    $sample = $db->table($tbl)->limit(2)->get()->getResultArray();
                    $info['sample'] = $sample;
                    // if bidang-related, try count by likely fk
                    $fk = null; foreach (['bidang_id','kategori','kategori_id','id_bidang'] as $col) { if (in_array($col, $fields, true)) { $fk = $col; break; } }
                    if ($fk) {
                        $rows = $db->table($tbl)->select("$fk as fk, COUNT(*) as cnt")->groupBy('fk')->limit(10)->get()->getResultArray();
                        $info['by_bidang'] = $rows;
                    }
                    $diag['sources'][] = $info;
                } catch (\Throwable $e) { /* skip */ }
            }
        } catch (\Throwable $e) {
            $diag['error'] = $e->getMessage();
        }
        return $this->response->setJSON($diag);
    }
}
