<?php
use CodeIgniter\Database\BaseConnection;

if (! function_exists('yearRencana')) {
    function yearRencana(): int { return 4; }
}

if (! function_exists('getKeberhasilanSpesifikLaporan')) {
    function getKeberhasilanSpesifikLaporan(int $y, string $bulan, int $indikatorId, int $pelaksanaId): array
    {
        $tahun = (int)('202' . $y);
        try {
            $row = dbx()->table('keberhasilan')
                ->where('tahun', $tahun)
                ->where('bulan', (int)$bulan)
                ->where('indikator_id', $indikatorId)
                ->where('pelaksana_id', $pelaksanaId)
                ->where('status', 2)
                ->get()->getRowArray();
            return $row ?: [];
        } catch (\Throwable $e) { return []; }
    }
}

// Period windows helpers (ported)
if (! function_exists('batas')) {
    function batas($bulan, $tahun, $pkran = false): bool
    {
        $tahun = (int)('202' . $tahun);
        if ($bulan == 6) { $bulan = 1; } elseif ($bulan == 12) { $bulan = 2; }
        try {
            $setting = dbx()->table('setting')->where('id', $bulan)->get()->getRowArray();
            if (!$setting) return true;
            $tahun1 = (int)($setting['tahun1'] ?? date('Y'));
            $tahun2 = (int)($setting['tahun2'] ?? date('Y'));
            $pertama = strtotime(sprintf('%02d-%02d-%04d', (int)$setting['tgl1'], (int)$setting['bulan1'], $tahun1));
            $kedua   = strtotime(sprintf('%02d-%02d-%04d', (int)$setting['tgl2'], (int)$setting['bulan2'], $tahun2));
            $newKedua = ($tahun == (int)date('Y'))
                ? strtotime(sprintf('%02d-%02d-%04d', (int)$setting['tgl2'], (int)$setting['bulan2'], $tahun2))
                : strtotime(sprintf('%02d-%02d-%04d', (int)$setting['tgl2'], (int)$setting['bulan2'], $tahun));
            $newTahun = ($bulan == 2 && (int)date('Y') > $tahun) ?  $tahun + 1 : $tahun;
            $currentDate = strtotime(date('d-M-' . $newTahun));
            if ((int)($setting['is_active'] ?? 1) === 1) {
                if ((int)date('Y') >= $tahun) {
                    if ($bulan == 1) { return ($currentDate >= $kedua); }
                    return ($currentDate >= $pertama);
                }
                return (strtotime(date('d-M-Y')) <= $newKedua);
            }
            return (strtotime(date('d-M-Y')) <= $newKedua);
        } catch (\Throwable $e) { return true; }
    }
}

if (! function_exists('batasRevisi')) {
    function batasRevisi($bulan, $tahun, $pkran = false): bool
    {
        $tahun = (int)('202' . $tahun);
        if ($bulan == 6) { $bulan = 1; } elseif ($bulan == 12) { $bulan = 2; }
        try {
            $check = dbx()->table('setting')->where('id', $bulan)->get()->getRowArray();
            $setting = dbx()->table('revisi')->where('id', $bulan)->get()->getRowArray();
            if (!$setting) return false;
            $tahun1 = (int)($setting['tahun1'] ?? date('Y'));
            $tahun2 = (int)($setting['tahun2'] ?? date('Y'));
            $pertama = strtotime(sprintf('%02d-%02d-%04d', (int)$setting['tgl1'], (int)$setting['bulan1'], $tahun1));
            $kedua   = strtotime(sprintf('%02d-%02d-%04d', (int)$setting['tgl2'], (int)$setting['bulan2'], $tahun2));
            $newKedua = ($tahun == (int)date('Y'))
                ? strtotime(sprintf('%02d-%02d-%04d', (int)$setting['tgl2'], (int)$setting['bulan2'], $tahun2))
                : strtotime(sprintf('%02d-%02d-%04d', (int)$setting['tgl2'], (int)$setting['bulan2'], $tahun));
            $newTahun = ($bulan == 2) ?  $tahun + 1 : $tahun;
            $currentDate = strtotime(date('d-M-' . $newTahun));
            if ((int)($check['is_active'] ?? 1) === 1) {
                if ((int)date('Y') >= $tahun) {
                    if ($bulan == 1) { return ($currentDate >= $kedua); }
                    return ($currentDate >= $pertama);
                }
                return (strtotime(date('d-M-Y')) <= $newKedua);
            }
            return (strtotime(date('d-M-Y')) <= $newKedua);
        } catch (\Throwable $e) { return false; }
    }
}

if (! function_exists('statusForm')) {
    function statusForm($keberhasilanId, $batas): string
    {
        // Simple indicator without link: show status of dukung by keberhasilan_id
        try {
            $row = dbx()->table('dukung')->where('keberhasilan_id', (int)$keberhasilanId)->get()->getRowArray();
            if (!$row) {
                return '<span class="inline-block px-2 py-0.5 rounded text-xs bg-rose-100 text-rose-700">Belum di isi</span>';
            }
            return '<span class="inline-block px-2 py-0.5 rounded text-xs bg-emerald-100 text-emerald-700">Sudah di isi</span>';
        } catch (\Throwable $e) {
            return '<span class="text-slate-400 text-xs">-</span>';
        }
    }
}

if (! function_exists('dbx')) {
    /** @return BaseConnection */
    function dbx() { return db_connect(); }
}

if (! function_exists('cekKeberhasilan')) {
    function cekKeberhasilan(int $y, int $pelaksanaId): bool
    {
        $tahun = (int)('202' . $y);
        try {
            return dbx()->table('keberhasilan')
                ->where('pelaksana_id', $pelaksanaId)
                ->where('tahun', $tahun)
                ->countAllResults() > 0;
        } catch (\Throwable $e) {
            return false;
        }
    }
}

if (! function_exists('spesifikIndikator')) {
    function spesifikIndikator(int $y, int $indikatorId): string
    {
        $tahun = '202' . $y;
        // Old app uses table spesifik_indikator.spesifik_indikator
        $candidates = [
            ['table' => 'spesifik_indikator', 'col' => 'spesifik_indikator'],
            ['table' => 'spesifik', 'col' => 'spesifik'],
            ['table' => 'indikator_spesifik', 'col' => 'spesifik'],
            ['table' => 'ukuran_keberhasilan', 'col' => 'ukuran'],
        ];
        foreach ($candidates as $c) {
            try {
                $row = dbx()->table($c['table'])
                    ->where('indikator_id', $indikatorId)
                    ->where('tahun', $tahun)
                    ->get()->getRowArray();
                if ($row && isset($row[$c['col']]) && $row[$c['col']] !== '') {
                    return (string)$row[$c['col']];
                }
            } catch (\Throwable $e) { /* ignore */ }
        }
        return '—';
    }
}

// Compatibility helpers for old_app pkran view
if (! function_exists('year')) {
    function year(): int
    {
        // mirror old year() range (0..year()) based on RAN 2020-2024 => 5 items (0..4)
        // use yearRencana() when available
        try { return (int)yearRencana(); } catch (\Throwable $e) { return 4; }
    }
}

if (! function_exists('getKeberhasilanSpesifik')) {
    /**
     * Return array like old_app: ['id'=>?, 'keberhasilan'=>string, 'status'=>int|null, 'catatan'=>string|null, 'note'=>array]
     */
    function getKeberhasilanSpesifik(int $y, string $bulan, int $indikatorId, int $pelaksanaId): array
    {
        $tahun = (int)('202' . $y);
        $res = [
            'id' => null,
            'keberhasilan' => null,
            'status' => null,
            'catatan' => null,
            'note' => [],
        ];
        try {
            $row = dbx()->table('keberhasilan')
                ->where('indikator_id', $indikatorId)
                ->where('pelaksana_id', $pelaksanaId)
                ->where('tahun', $tahun)
                ->where('bulan', (int)$bulan)
                ->get()->getRowArray();
            if ($row) {
                $res['id'] = $row['id'] ?? null;
                $res['keberhasilan'] = $row['keberhasilan'] ?? ($row['target'] ?? null);
                $res['status'] = $row['status'] ?? ($row['status_eval'] ?? null);
                $res['catatan'] = $row['catatan'] ?? ($row['catatan_eval'] ?? null);
                // load optional notes if exists (table: keberhasilan_note)
                try {
                    $notes = dbx()->table('keberhasilan_note')->where('keberhasilan_id', (int)$res['id'])->get()->getResultArray();
                    if ($notes) { $res['note'] = $notes; }
                } catch (\Throwable $e) { /* ignore */ }
            }
        } catch (\Throwable $e) { /* ignore */ }
        return $res;
    }
}

if (! function_exists('status')) {
    function status($status, $catatan = null): string
    {
        $map = [
            1 => '<span class="badge bg-success">Approved</span>',
            2 => '<span class="badge bg-danger">Rejected</span>',
            0 => '<span class="badge bg-warning text-dark">Pending</span>',
            3 => '<span class="badge bg-secondary">Revisi</span>',
        ];
        $k = is_numeric($status) ? (int)$status : 0;
        return $map[$k] ?? $map[0];
    }
}

if (! function_exists('kondisiPkran')) {
    function kondisiPkran(int $bulan, int $y, $status): bool
    {
        // Editable when no status or status is 0 or 3 (pending or revisi)
        if ($status === null) return true;
        $k = is_numeric($status) ? (int)$status : 0;
        return in_array($k, [0,3], true);
    }
}

if (! function_exists('getKeberhasilanSpesifikRencana')) {
    function getKeberhasilanSpesifikRencana(int $y, int $bln, int $indikatorId, int $pelaksanaId): string
    {
        $tahun = (int)('202' . $y);
        // Best guess table for target spesifik
        $candidates = [
            ['table' => 'spesifik', 'col' => 'spesifik'],
            ['table' => 'indikator_spesifik', 'col' => 'spesifik'],
            ['table' => 'target_spesifik', 'col' => 'target'],
        ];
        foreach ($candidates as $c) {
            try {
                $row = dbx()->table($c['table'])
                    ->where('indikator_id', $indikatorId)
                    ->where('pelaksana_id', $pelaksanaId)
                    ->where('tahun', $tahun)
                    ->where('bulan', $bln)
                    ->get()->getRowArray();
                if ($row && isset($row[$c['col']]) && $row[$c['col']] !== '') {
                    return (string)$row[$c['col']];
                }
            } catch (\Throwable $e) { /* ignore */ }
        }
        return '—';
    }
}

if (! function_exists('getArrayKeberhasilan')) {
    function getArrayKeberhasilan(int $y, int $bln, int $indikatorId, int $pelaksanaId): array
    {
        $tahun = (int)('202' . $y);
        $res = [
            'id' => null,
            'progress' => 0,
            'status_eval' => null,
            'catatan_eval' => null,
        ];
        try {
            $row = dbx()->table('keberhasilan')
                ->where('indikator_id', $indikatorId)
                ->where('pelaksana_id', $pelaksanaId)
                ->where('tahun', $tahun)
                ->where('bulan', $bln)
                ->get()->getRowArray();
            if ($row) {
                $res['id'] = $row['id'] ?? null;
                $res['progress'] = (int)($row['progress'] ?? 0);
                $res['status_eval'] = $row['status_eval'] ?? null;
                $res['catatan_eval'] = $row['catatan_eval'] ?? null;
            }
        } catch (\Throwable $e) { /* ignore */ }
        return $res;
    }
}

if (! function_exists('evaluatorStatus')) {
    function evaluatorStatus($status): string
    {
        $map = [
            1 => '<span class="inline-block px-2 py-0.5 rounded text-xs bg-emerald-100 text-emerald-700">Approved</span>',
            2 => '<span class="inline-block px-2 py-0.5 rounded text-xs bg-rose-100 text-rose-700">Rejected</span>',
            0 => '<span class="inline-block px-2 py-0.5 rounded text-xs bg-amber-100 text-amber-700">Pending</span>',
        ];
        $k = is_numeric($status) ? (int)$status : 0;
        return $map[$k] ?? $map[0];
    }
}

if (! function_exists('statusFormAdmin')) {
    function statusFormAdmin($keberhasilanId, $pelaksanaId): string
    {
        // Placeholder link; adjust to your data-dukung route if different
        if (!$keberhasilanId) return '<span class="text-slate-400">-</span>';
        $url = site_url('admin/laporan/data-dukung/'.$keberhasilanId);
        return '<a class="text-indigo-600 hover:text-indigo-700 text-sm" target="_blank" rel="noopener" href="'.$url.'">Lihat</a>';
    }
}
