<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;
use App\Models\PemantauanModel;

class Pemantauan extends BaseController
{
    public function index()
    {
        helper('pemantauan');
        $db = db_connect();
        $level1Options = [];
        // Role-based Level1 options (mirror old_app behavior)
        $roleStr = strtolower((string)(session('role') ?? ''));
        $parts = explode(' ', $roleStr);
        $roleTail = trim(($parts && end($parts)) ? end($parts) : '');
        try {
            if ($roleTail === 'kab/kota') {
                $lvl1 = (int)(session('level1') ?? 0);
                if ($lvl1 > 0) {
                    $level1Options = $db->table('level1')->where('id', $lvl1)->get()->getResultArray();
                }
            } elseif ($roleTail === 'provinsi') {
                // old_app selects id 5 or 6 for provinsi
                $level1Options = $db->table('level1')->groupStart()->where('id', 5)->orWhere('id', 6)->groupEnd()->get()->getResultArray();
            } else {
                $level1Options = $db->table('level1')->get()->getResultArray();
            }
        } catch (\Throwable $e) {
            $level1Options = [];
        }

        $qLevel1 = (string)$this->request->getGet('level1_id');
        $qLevel2 = (string)$this->request->getGet('level2_id');
        $qLevel3 = (string)$this->request->getGet('level3_id');

        $rencana = [];
        $bulan = [6,12];
        if ($qLevel1 !== '' && ($qLevel2 !== '' || $qLevel3 !== '')) {
            $m = new PemantauanModel();
            $level1 = $qLevel1 !== '' ? (int)$qLevel1 : null;
            $level2 = $qLevel2 !== '' ? (int)$qLevel2 : null;
            $level3 = $qLevel3 !== '' ? (int)$qLevel3 : null;
            $rencana = $m->getRencana($level1, $level2, $level3);
        }

        return view('admin/pemantauan/index', [
            'title' => 'Pemantauan',
            'level1' => $level1Options,
            'rencana' => $rencana,
            'bulan' => $bulan,
            'g1' => $qLevel1,
            'g2' => $qLevel2,
            'g3' => $qLevel3,
            // for select defaults (optional)
            'select2' => null,
            'select3' => null,
        ]);
    }
}
