<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;
use App\Models\CapaianOutputModel;

class Rangking extends BaseController
{
    public function index()
    {
        helper(['laporan', 'url']);
        $periode = (string)($this->request->getGet('periode') ?? '');
        $rencana = (int)($this->request->getGet('rencana') ?? 0);
        $pelaksana = (int)($this->request->getGet('pelaksana') ?? 0);
        $indikator = (int)($this->request->getGet('indikator') ?? 0);
        $rows = [];
        if ($periode !== '' && $rencana && $pelaksana && $indikator) {
            [$tahun, $bulan] = explode('_', $periode) + [0=>0,1=>0];
            $tahun = (int)$tahun; $bulan = (int)$bulan;
            $model = new CapaianOutputModel();
            $data = $model->getCapaian($rencana, $tahun, $bulan, $pelaksana, $indikator);
            $rows = mergeCapaian($data);
        }
        return view('admin/laporan/rangking', [
            'title' => 'Laporan - Rangking',
            'periode' => $periode,
            'rencanaSel' => $rencana,
            'pelaksanaSel' => $pelaksana,
            'indikatorSel' => $indikator,
            'rows' => $rows,
        ]);
    }
}
