<?php $isModal = (bool)($modal ?? false); $val = $value ?? []; ?>
<?php if (!$isModal): ?>
<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Form User',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Management User']
]) ?>
  <div class="mb-6">
    <h1 class="text-2xl font-bold"><?= esc($title ?? 'Form User') ?></h1>
  </div>
  <section class="pb-6">
<?php endif; ?>

  <?php if (session()->getFlashdata('error')): ?>
    <div class="mb-4 p-3 rounded bg-rose-50 text-rose-700 border border-rose-200">
      <?= esc(session()->getFlashdata('error')) ?>
    </div>
  <?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <form method="post" action="<?= esc($action ?? '') ?>" class="grid grid-cols-1 gap-4">
      <?= csrf_field() ?>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm text-slate-600 mb-1">Nama</label>
          <input name="nama" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc($val['nama'] ?? '') ?>" required />
        </div>
        <div>
          <label class="block text-sm text-slate-600 mb-1">Username</label>
          <input name="username" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc($val['username'] ?? '') ?>" required />
        </div>
      </div>

      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm text-slate-600 mb-1">Password <?= isset($val['id']) ? '(opsional)' : '' ?></label>
          <input name="password" type="password" class="w-full border rounded-lg px-3 py-2" placeholder="<?= isset($val['id']) ? 'Biarkan kosong jika tidak diubah' : '' ?>" />
        </div>
        <div>
          <label class="block text-sm text-slate-600 mb-1">Role</label>
          <select name="role_id" class="w-full border rounded-lg px-3 py-2" required>
            <option value="">- Pilih Role -</option>
            <?php foreach (($roles ?? []) as $r): $sel = ((string)($val['role_id'] ?? '') === (string)($r['id'] ?? '')) ? 'selected' : ''; ?>
              <option value="<?= (int)($r['id'] ?? 0) ?>" <?= $sel ?>><?= esc($r['role'] ?? '-') ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>

      <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div>
          <label class="block text-sm text-slate-600 mb-1">Level 1</label>
          <select name="level1_id" class="w-full border rounded-lg px-3 py-2">
            <option value="">-</option>
            <?php foreach (($levels['l1'] ?? []) as $o): $sel = ((string)($val['level1_id'] ?? '') === (string)($o['id'] ?? '')) ? 'selected' : ''; ?>
              <option value="<?= (int)($o['id'] ?? 0) ?>" <?= $sel ?>><?= esc($o['level1'] ?? '-') ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label class="block text-sm text-slate-600 mb-1">Level 2</label>
          <select name="level2_id" class="w-full border rounded-lg px-3 py-2">
            <option value="">-</option>
            <?php foreach (($levels['l2'] ?? []) as $o): $sel = ((string)($val['level2_id'] ?? '') === (string)($o['id'] ?? '')) ? 'selected' : ''; ?>
              <option value="<?= (int)($o['id'] ?? 0) ?>" <?= $sel ?>><?= esc($o['level2'] ?? '-') ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label class="block text-sm text-slate-600 mb-1">Level 3</label>
          <select name="level3_id" class="w-full border rounded-lg px-3 py-2">
            <option value="">-</option>
            <?php foreach (($levels['l3'] ?? []) as $o): $sel = ((string)($val['level3_id'] ?? '') === (string)($o['id'] ?? '')) ? 'selected' : ''; ?>
              <option value="<?= (int)($o['id'] ?? 0) ?>" <?= $sel ?>><?= esc($o['level3'] ?? '-') ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>

      <div>
        <label class="block text-sm text-slate-600 mb-1">No HP</label>
        <input name="no_hp" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc($val['no_hp'] ?? '') ?>" />
      </div>

      <div class="flex justify-end gap-2 mt-4">
        <?php if (!$isModal): ?>
          <a href="<?= base_url('admin/user') ?>" class="px-4 py-2 rounded-lg border">Batal</a>
        <?php endif; ?>
        <button type="submit" class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700"><?= esc($submitLabel ?? 'Simpan') ?></button>
      </div>
    </form>
  </div>

<?php if (!$isModal): ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
<?php endif; ?>
