<?php $isModal = (bool)($modal ?? false); ?>
<?php if (!$isModal): ?>
<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Detail Group Wilayah',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Master','Group Wilayah']
]) ?>
  <div class="mb-6">
    <h1 class="text-2xl font-bold">Detail Group Wilayah</h1>
  </div>
  <section class="pb-6">
<?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <div class="grid grid-cols-1 gap-3 text-sm">
      <?php foreach (($row ?? []) as $k => $v): ?>
        <div class="flex items-start gap-3">
          <div class="w-40 text-slate-500 capitalize"><?= esc($k) ?></div>
          <div class="flex-1 text-slate-800 break-all"><?= esc((string)$v) ?></div>
        </div>
      <?php endforeach; ?>
    </div>
    <?php if (!$isModal): ?>
    <div class="flex justify-end gap-2 mt-6">
      <a href="<?= base_url('admin/master/group_wilayah') ?>" class="px-4 py-2 rounded-lg border">Kembali</a>
    </div>
    <?php endif; ?>
  </div>

<?php if (!$isModal): ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
<?php endif; ?>
