<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Master - Wilayah',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Master','Wilayah']
]) ?>

  <div class="mb-6 flex items-center justify-between">
    <div>
      <h1 class="text-2xl font-bold">Master - Wilayah</h1>
      <p class="text-slate-500">Daftar Wilayah</p>
    </div>
    <a href="<?= base_url('admin/master/wilayah/create') ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm">
      <i data-lucide="plus" class="w-4 h-4"></i>
      <span>Tambah</span>
    </a>
  </div>

  <section class="pb-6">
    <?php
      echo view('components/data-table', [
        'id' => 'dt_wilayah',
        'headers' => [
          ['key' => 'no', 'label' => 'No', 'noSort' => true],
          ['key' => 'name', 'label' => 'Nama Wilayah'],
          ['key' => 'actions', 'label' => 'Aksi', 'raw' => true],
        ],
        'rows' => array_values($rows ?? []),
        'pageSize' => 10,
      ]);
    ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
