<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Rencana Aksi',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Rencana']
]) ?>

  <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-start sm:justify-between">
    <div class="shrink min-w-0">
      <h1 class="text-2xl font-bold">Rencana Aksi</h1>
      <?php if (!empty($program)): ?>
        <p class="text-slate-500">Program: <?= esc((string)($program['kode'] ?? '')) ?> - <?= esc((string)($program['nama'] ?? '')) ?></p>
      <?php endif; ?>
    </div>
    <div class="flex flex-wrap items-center gap-2">
      <a href="<?= base_url('admin/program'.(!empty($program['bidang_id'])?('?id='.(int)$program['bidang_id']):'')) ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm">
        <i data-lucide="arrow-left" class="w-4 h-4"></i>
        <span>Kembali</span>
      </a>
    </div>
  </div>

  <section class="pb-6">
    <?php
      echo view('components/data-table', [
        'id' => 'dt_rencana',
        'headers' => [
          ['key' => 'no', 'label' => 'No', 'noSort' => true],
          ['key' => 'kode', 'label' => 'Kode'],
          ['key' => 'nama', 'label' => 'Rencana Aksi'],
          ['key' => 'status', 'label' => 'Status Pelaksana'],
          ['key' => 'indikator', 'label' => 'Indikator Keberhasilan', 'raw' => true],
          ['key' => 'actions', 'label' => 'Aksi', 'raw' => true],
        ],
        'rows' => array_values($rows ?? []),
        'pageSize' => 10,
      ]);
    ?>
  </section>

<?= view('layouts/dashboard_footer') ?>
