<?php
// Modal body for managing Indikator Keberhasilan of a Rencana
?>
<div class="space-y-4">
  <div>
    <div class="text-sm font-semibold text-slate-700">Indikator Keberhasilan</div>
    <div class="text-xs text-slate-500">Rencana: <?= esc((string)($rencana['kode'] ?? '')) ?> - <?= esc((string)($rencana['nama'] ?? '')) ?></div>
  </div>

  <form method="post" action="<?= base_url('admin/rencana/indikator/store') ?>" class="grid grid-cols-1 gap-3">
    <?= csrf_field() ?>
    <input type="hidden" name="rencana_id" value="<?= (int)($rencana['id'] ?? 0) ?>" />
    <div>
      <label class="block text-sm text-slate-600 mb-1">Tambah Indikator</label>
      <textarea name="indikator" rows="3" class="w-full border rounded-lg px-3 py-2" placeholder="Tulis indikator baru..."></textarea>
    </div>
    <div class="flex justify-end">
      <button type="submit" class="px-3 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">Simpan</button>
    </div>
  </form>

  <div class="border-t pt-3">
    <div class="text-sm font-semibold text-slate-700 mb-2">Daftar Indikator</div>
    <div class="overflow-x-auto">
      <table class="min-w-full divide-y divide-slate-200 text-sm">
        <thead class="bg-slate-50">
          <tr>
            <th class="px-3 py-2 text-left text-slate-600">No</th>
            <th class="px-3 py-2 text-left text-slate-600">Indikator</th>
            <th class="px-3 py-2 text-right text-slate-600">Aksi</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-slate-100 bg-white">
          <?php $no=1; foreach (($items ?? []) as $it): ?>
            <tr>
              <td class="px-3 py-2 text-slate-700"><?= $no++ ?></td>
              <td class="px-3 py-2 text-slate-700 break-words"><?= esc((string)($it['indikator'] ?? '')) ?></td>
              <td class="px-3 py-2 text-right">
                <form method="post" action="<?= base_url('admin/rencana/indikator/delete/'.(int)($it['id'] ?? 0)) ?>" data-confirm="Yakin hapus indikator ini?" class="inline">
                  <?= csrf_field() ?>
                  <button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600" title="Hapus" aria-label="Hapus">
                    <i data-lucide="trash-2" class="w-4 h-4"></i>
                  </button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($items)): ?>
            <tr>
              <td colspan="3" class="px-3 py-4 text-center text-slate-500">Belum ada indikator</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
