<?php
namespace Modules\Eksekutif\Controllers;

use CodeIgniter\Controller;

class Progres extends Controller
{
    public function detail()
    {
        helper(['url']);
        $rencanaId = (int) ($this->request->getGet('rencana_id') ?? 0);
        $pelaksanaId = (int) ($this->request->getGet('pelaksana_id') ?? 0);
        $periode = (string) ($this->request->getGet('periode') ?? '');
        // periode like 2020_6 or 2024_12
        $tahun = 0; $bulanSelected = 0;
        if (strpos($periode, '_') !== false) {
            [$t, $b] = explode('_', $periode, 2);
            $tahun = (int) $t; $bulanSelected = (int) $b;
        }
        if ($tahun === 0) { $tahun = (int) ($this->request->getGet('tahun') ?? date('Y')); }
        if ($bulanSelected === 0) { $bulanSelected = 12; }
        if ($rencanaId <= 0 || $pelaksanaId <= 0) {
            return redirect()->to(base_url('admin/laporan'));
        }

        $db = db_connect();
        // Fetch rencana info (minimal, avoid failing joins if tables differ)
        $rencana = $db->table('rencana')->select('id, kode, aksi')->where('id', $rencanaId)->get()->getRowArray() ?? [];
        // Try to enrich bidang/program names if tables exist
        try {
            if (isset($rencana['bidang_id']) && !empty($rencana['bidang_id'])) {
                $rb = $db->table('bidang')->select('bidang')->where('id', (int)$rencana['bidang_id'])->get()->getRowArray();
                if ($rb) { $rencana['bidang'] = $rb['bidang'] ?? null; }
            }
        } catch (\Throwable $e) { /* ignore */ }
        try {
            if (isset($rencana['program_id']) && !empty($rencana['program_id'])) {
                $rp = $db->table('program')->select('program')->where('id', (int)$rencana['program_id'])->get()->getRowArray();
                if ($rp) { $rencana['program'] = $rp['program'] ?? null; }
            }
        } catch (\Throwable $e) { /* ignore */ }
        $indikators = $db->table('indikator')->select('id, indikator')->where('rencana_id', $rencanaId)->orderBy('id', 'ASC')->get()->getResultArray();
        $indikatorTexts = array_map(function($x){ return (string)($x['indikator'] ?? ''); }, $indikators);
        // Prefetch spesifik_indikator texts for current tahun
        $spesifikMap = [];
        try {
            $ids = array_map(function($x){ return (int)($x['id'] ?? 0); }, $indikators);
            if (!empty($ids)) {
                $rowsSpec = $db->table('spesifik_indikator')->select('indikator_id, spesifik_indikator')->where('tahun', $tahun)->whereIn('indikator_id', $ids)->get()->getResultArray();
                foreach ($rowsSpec as $rs) { $spesifikMap[(int)$rs['indikator_id']] = (string)($rs['spesifik_indikator'] ?? ''); }
            }
        } catch (\Throwable $e) { /* ignore */ }

        // Helper to get a keberhasilan record for given indikator and bulan
        $getKeb = function(int $tahun, int $bulan, int $indikatorId, int $pelaksanaId) use ($db) {
            $row = $db->table('keberhasilan')
                ->select('id, progress, status_eval, catatan_eval')
                ->where(['tahun' => $tahun, 'bulan' => $bulan, 'indikator_id' => $indikatorId, 'pelaksana_id' => $pelaksanaId])
                ->get()->getRowArray();
            if (!$row) { return null; }
            // data dukung presence
            $dukung = $db->table('dukung')->where('keberhasilan_id', $row['id'])->countAllResults();
            // catatan list
            $notes = $db->table('catatan')->select('catatan_eval')->where('keberhasilan_id', $row['id'])->orderBy('id','ASC')->get()->getResultArray();
            return [
                'id' => (int) $row['id'],
                'progress' => (float) ($row['progress'] ?? 0),
                'status_eval' => $row['status_eval'] !== null ? (int) $row['status_eval'] : null,
                'catatan_eval' => (string) ($row['catatan_eval'] ?? ''),
                'dukung' => (int) $dukung,
                'notes' => array_map(function($n){ return (string)($n['catatan_eval'] ?? ''); }, $notes),
            ];
        };

        // Build per-indikator data for bulan 6 and 12
        $bulanList = [6, 12];
        $items = [];
        foreach ($indikators as $idk) {
            $idkId = (int) ($idk['id'] ?? 0);
            $entry = [
                'id' => $idkId,
                'indikator' => (string) ($idk['indikator'] ?? ''),
                'tahun' => $tahun,
                'rows' => [],
            ];
            foreach ($bulanList as $b) {
                $k = $getKeb($tahun, $b, $idkId, $pelaksanaId);
                $entry['rows'][] = [
                    'bulan' => $b,
                    'keberhasilan' => $k,
                ];
            }
            $items[] = $entry;
        }

        return view('eksekutif/progres/detail', [
            'rencana' => $rencana,
            'pelaksana_id' => $pelaksanaId,
            'tahun' => $tahun,
            'bulan_selected' => $bulanSelected,
            'items' => $items,
            'indikator_texts' => $indikatorTexts,
            'spesifik_map' => $spesifikMap,
        ]);
    }
}
