<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Laporan',
  'active' => 'laporan',
  'breadcrumb' => ['Eksekutif','Laporan']
]) ?>
    <div class="bg-white rounded-2xl shadow p-6">
      <div class="flex items-center justify-between mb-4">
        <div>
          <h4 class="text-lg font-semibold text-slate-800">Tahun</h4>
          <p class="text-slate-600 text-sm">Anda dapat memilih laporan berdasarkan field di bawah</p>
        </div>
      </div>
      <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-5">
        <?php foreach (($tahun_history ?? []) as $i => $val): ?>
          <a class="group relative rounded-2xl border border-slate-200 p-5 bg-gradient-to-br from-indigo-50 to-white hover:from-white hover:to-white hover:shadow-md transition" href="<?= base_url('eksekutif/laporan/rencana?tahun='.(int)($val['tahun']??0).'&status=true') ?>">
            <div class="absolute right-4 top-4 inline-flex items-center gap-1 text-xs px-2 py-1 rounded-full bg-indigo-100 text-indigo-700">
              <span class="w-1.5 h-1.5 rounded-full bg-indigo-600"></span>
              No <?= $i + 1 ?>
            </div>
            <div class="flex items-center gap-3 mb-3">
              <div class="shrink-0 w-10 h-10 rounded-xl bg-indigo-600/10 text-indigo-700 grid place-items-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M8 7V3m8 4V3M3 11h18M5 19h14a2 2 0 0 0 2-2v-6H3v6a2 2 0 0 0 2 2z"/></svg>
              </div>
              <div>
                <div class="text-xs uppercase tracking-wide text-slate-500">Tahun</div>
                <div class="text-xl font-semibold text-slate-800 leading-tight"><?= esc($val['tahun'] ?? '-') ?></div>
              </div>
            </div>
            <div class="mt-2">
              <div class="text-xs text-slate-500 mb-1">Jumlah Aksi</div>
              <div class="text-3xl font-bold text-slate-900">
                <?= number_format((int)($val['jumlah'] ?? 0), 0, ',', '.') ?>
              </div>
            </div>
            <div class="mt-4 inline-flex items-center gap-2 text-indigo-700 group-hover:text-indigo-800 text-sm">
              Lihat Rencana
              <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 18l6-6-6-6"/></svg>
            </div>
          </a>
        <?php endforeach; ?>
        <?php if (empty($tahun_history ?? [])): ?>
          <div class="text-slate-500">Tidak ada data</div>
        <?php endif; ?>
      </div>
    </div>
<?= view('layouts/dashboard_footer') ?>
