<?php
namespace Modules\Evaluator\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\I18n\Time;

class Dashboard extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $now = Time::now();

        $roleId = (int)(session('role_id') ?? 0);
        // Counts (mirror old_app logic)
        try {
            // Permohonan Masuk: keberhasilan.status = 1 (with role filter)
            $b = $db->table('keberhasilan k')
                ->select('COUNT(*) as jumlah')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status', 1);
            $permohonan = (int)($b->get()->getRowArray()['jumlah'] ?? 0);
        } catch (\Throwable $e) { $permohonan = 0; }
        try {
            // Permohonan History: keberhasilan.status not in (1,0)
            $b = $db->table('keberhasilan k')
                ->select('COUNT(*) as jumlah')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status IS NOT NULL', null, false)
                ->where('k.status <>', 1)
                ->where('k.status <>', 0);
            $permohonan_history = (int)($b->get()->getRowArray()['jumlah'] ?? 0);
        } catch (\Throwable $e) { $permohonan_history = 0; }
        try {
            // Progress Masuk: status_eval = 1 (awaiting evaluation)
            $b = $db->table('keberhasilan k')
                ->select('COUNT(*) as jumlah')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status_eval', 1);
            $progress = (int)($b->get()->getRowArray()['jumlah'] ?? 0);
        } catch (\Throwable $e) { $progress = 0; }
        try {
            // Progress History: status_eval not in (1,0) and not null
            $b = $db->table('keberhasilan k')
                ->select('COUNT(*) as jumlah')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status_eval IS NOT NULL', null, false)
                ->where('k.status_eval <>', 1)
                ->where('k.status_eval <>', 0);
            $progress_history = (int)($b->get()->getRowArray()['jumlah'] ?? 0);
        } catch (\Throwable $e) { $progress_history = 0; }

        // Notifications: pending progress to evaluate
        try {
            // Build subquery like old_app: base where status_eval = 1, then outer filter status IS NOT NULL
            $base = $db->table('keberhasilan k')
                ->select('l1.level as level1, l2.level as level2, l3.level as level3, k.tanggal_progres, pr.program, r.aksi, k.id, k.pelaksana_id, k.status, k.tahun, p.rencana_id')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('rencana r', 'r.id = p.rencana_id', 'left')
                ->join('program pr', 'pr.id = r.program_id', 'left')
                ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                ->join('level2 l2', 'l2.id = p.level2_id', 'left')
                ->join('level3 l3', 'l3.id = p.level3_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status_eval', 1)
                ->getCompiledSelect();

            $notifikasi = $db->table("($base) as permohonan")
                ->select('level1, level2, level3, tanggal_progres, program, aksi, id, pelaksana_id, status, tahun, rencana_id')
                ->where('status IS NOT NULL', null, false)
                ->orderBy('tanggal_progres', 'DESC')
                ->limit(10)
                ->get()->getResultArray();
            if (empty($notifikasi)) {
                // Fallback A: allow status NULL too (still status_eval = 1)
                $notifikasi = $db->table("($base) as permohonan")
                    ->select('level1, level2, level3, tanggal_progres, program, aksi, id, pelaksana_id, status, tahun, rencana_id')
                    ->orderBy('tanggal_progres', 'DESC')
                    ->limit(10)
                    ->get()->getResultArray();
            }
            if (empty($notifikasi)) {
                // Fallback B: drop role filter (in case set_eval mapping differs), keep status_eval = 1
                $baseNoRole = $db->table('keberhasilan k')
                    ->select('l1.level as level1, l2.level as level2, l3.level as level3, k.tanggal_progres, pr.program, r.aksi, k.id, k.pelaksana_id, k.status, k.tahun, p.rencana_id')
                    ->join('indikator i', 'i.id = k.indikator_id', 'left')
                    ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                    ->join('rencana r', 'r.id = p.rencana_id', 'left')
                    ->join('program pr', 'pr.id = r.program_id', 'left')
                    ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                    ->join('level2 l2', 'l2.id = p.level2_id', 'left')
                    ->join('level3 l3', 'l3.id = p.level3_id', 'left')
                    ->where('k.status_eval', 1)
                    ->getCompiledSelect();
                $notifikasi = $db->table("($baseNoRole) as permohonan")
                    ->select('level1, level2, level3, tanggal_progres, program, aksi, id, pelaksana_id, status, tahun, rencana_id')
                    ->orderBy('tanggal_progres', 'DESC')
                    ->limit(10)
                    ->get()->getResultArray();
            }
        } catch (\Throwable $e) {
            $notifikasi = [];
        }

        return view('Modules\\Evaluator\\Views\\dashboard', [
            'title' => 'Dashboard',
            'permohonan' => $permohonan,
            'permohonan_history' => $permohonan_history,
            'progress' => $progress,
            'progress_history' => $progress_history,
            'notifikasi' => $notifikasi,
        ]);
    }
}
