<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Dokumentasi',
  'active' => 'dokumentasi',
  'breadcrumb' => ['Evaluator', 'Dokumentasi']
]) ?>

  <div class="bg-white rounded-2xl shadow border border-slate-200 p-6 space-y-6">
    <div class="bg-gradient-to-r from-indigo-600 to-sky-500 rounded-2xl p-6 text-white shadow">
      <h1 class="text-2xl font-bold">Dokumentasi Penggunaan</h1>
      <p class="text-white/90 mt-1 text-sm">Panduan cepat dan video untuk menggunakan aplikasi INPRES No. 2 Tahun 2020.</p>
    </div>

    <?php $items = $doc ?? []; $count = count($items); ?>
    <?php if ($count > 0): ?>
      <div class="space-y-4">
        <div class="grid grid-cols-1 gap-4">
        <?php foreach ($items as $i => $val):
          $desc = (string)($val['desc'] ?? '-');
          $f = trim((string)($val['file'] ?? ''));
          $isUrl = (strpos($f, 'http://') === 0 || strpos($f, 'https://') === 0);
          $ext = strtolower(pathinfo(parse_url($f, PHP_URL_PATH) ?? '', PATHINFO_EXTENSION));
          $isVideoFile = in_array($ext, ['mp4','webm','ogg'], true);
          $isYouTube = $isUrl && (strpos($f, 'youtube.com') !== false || strpos($f, 'youtu.be') !== false);
          $isVimeo = $isUrl && (strpos($f, 'vimeo.com') !== false);
          // Normalize local path relative to public/ docroot
          if (!$isUrl) {
            $path = ltrim($f, '/');
            if (strpos($path, 'public/') === 0) { $path = substr($path, 7); }
            $publicUrl = base_url($path);
          } else {
            $publicUrl = $f;
          }
          $ytEmbed = '';
          if ($isYouTube) {
            $yt = $f;
            if (preg_match('~youtu\.be/([A-Za-z0-9_-]{6,})~', $yt, $m)) { $ytEmbed = 'https://www.youtube.com/embed/' . $m[1]; }
            elseif (preg_match('~v=([A-Za-z0-9_-]{6,})~', $yt, $m)) { $ytEmbed = 'https://www.youtube.com/embed/' . $m[1]; }
          }
        ?>
          <div class="<?php echo ($i>0 ? 'border-t border-slate-200 pt-4' : ''); ?>">
            <div class="flex items-start gap-3">
              <span class="inline-flex items-center justify-center w-7 h-7 rounded-full bg-indigo-600 text-white text-xs font-bold">
                <?= $i+1 ?>
              </span>
              <div class="flex-1">
                <div class="text-slate-800 font-semibold"><?= esc($desc) ?></div>
                <?php if ($f !== ''): ?>
                  <div class="mt-4">
                    <?php if ($isVideoFile): ?>
                      <div class="relative w-full overflow-hidden rounded-lg border border-slate-200 bg-black/5">
                        <video class="w-full h-auto" controls preload="metadata" src="<?= esc($publicUrl) ?>"></video>
                      </div>
                    <?php elseif ($isYouTube && $ytEmbed !== ''): ?>
                      <div class="relative w-full overflow-hidden rounded-lg border border-slate-200" style="aspect-ratio: 16/9;">
                        <iframe class="w-full h-full" src="<?= esc($ytEmbed) ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                      </div>
                    <?php elseif ($isVimeo): ?>
                      <div class="relative w-full overflow-hidden rounded-lg border border-slate-200" style="aspect-ratio: 16/9;">
                        <iframe class="w-full h-full" src="<?= esc($publicUrl) ?>" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
                      </div>
                    <?php else: ?>
                      <a class="inline-flex items-center gap-2 text-indigo-600 hover:text-indigo-700 text-sm font-medium" href="<?= esc($publicUrl) ?>" target="_blank" rel="noopener">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M7 10v12"/><path d="M15 5l-7 7 7 7"/></svg>
                        <span>Buka File</span>
                      </a>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
        </div>
      </div>
    <?php else: ?>
      <div class="bg-white rounded-2xl shadow border border-slate-200 p-6 text-slate-600 text-sm">Belum ada data dokumentasi.</div>
    <?php endif; ?>
  </div>

<?= view('layouts/dashboard_footer') ?>
