<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Permohonan',
  'active' => 'permohonan',
  'breadcrumb' => ['Evaluator', 'Permohonan']
]) ?>

<div class="bg-white rounded-2xl shadow p-6">
  <h4 class="text-lg font-semibold">Tahun</h4>
  <p class="text-sm text-slate-500">Anda dapat memilih permohonan berdasarkan field di bawah</p>

  <div class="mt-4">
    <div class="border-b border-slate-200">
      <nav class="-mb-px flex space-x-8" aria-label="Tabs">
        <button type="button" class="tab-btn border-b-2 border-indigo-500 py-2 px-1 text-indigo-600 font-medium text-sm" data-tab="permohonan">
          Permohonan
        </button>
        <button type="button" class="tab-btn border-b-2 border-transparent py-2 px-1 text-slate-500 hover:text-slate-700 hover:border-slate-300 font-medium text-sm" data-tab="history">
          History
        </button>
      </nav>
    </div>

    <div class="mt-4">
      <!-- Permohonan Tab -->
      <div id="tab-permohonan" class="tab-content">
        <div class="overflow-x-auto">
          <table class="min-w-full divide-y divide-slate-200">
            <thead class="bg-slate-50">
              <tr>
                <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">No</th>
                <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Tahun</th>
                <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Jumlah Aksi</th>
              </tr>
            </thead>
            <tbody class="bg-white divide-y divide-slate-200">
              <?php if (empty($tahun ?? [])): ?>
                <tr><td colspan="3" class="px-4 py-6 text-center text-slate-500">Belum ada data</td></tr>
              <?php else: ?>
                <?php foreach (($tahun ?? []) as $i => $val): ?>
                  <tr class="hover:bg-slate-50 cursor-pointer" onclick="window.location.href='<?= site_url('evaluator/permohonan/rencana?tahun='.(int)($val['tahun'] ?? 0)) ?>'">
                    <td class="px-4 py-3 whitespace-nowrap text-sm"><?= $i + 1 ?></td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm font-medium"><?= esc((string)($val['tahun'] ?? '')) ?></td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm"><?= (int)($val['jumlah'] ?? 0) ?></td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>

      <!-- History Tab -->
      <div id="tab-history" class="tab-content hidden">
        <div class="overflow-x-auto">
          <table class="min-w-full divide-y divide-slate-200">
            <thead class="bg-slate-50">
              <tr>
                <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">No</th>
                <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Tahun</th>
                <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Jumlah Aksi</th>
              </tr>
            </thead>
            <tbody class="bg-white divide-y divide-slate-200">
              <?php if (empty($tahun_history ?? [])): ?>
                <tr><td colspan="3" class="px-4 py-6 text-center text-slate-500">Belum ada data</td></tr>
              <?php else: ?>
                <?php foreach (($tahun_history ?? []) as $i => $val): ?>
                  <tr class="hover:bg-slate-50 cursor-pointer" onclick="window.location.href='<?= site_url('evaluator/permohonan/rencana?tahun='.(int)($val['tahun'] ?? 0).'&status=true') ?>'">
                    <td class="px-4 py-3 whitespace-nowrap text-sm"><?= $i + 1 ?></td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm font-medium"><?= esc((string)($val['tahun'] ?? '')) ?></td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm"><?= (int)($val['jumlah'] ?? 0) ?></td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<?= view('layouts/dashboard_footer') ?>

<script>
document.querySelectorAll('.tab-btn').forEach(btn => {
  btn.addEventListener('click', function() {
    const targetTab = this.dataset.tab;
    document.querySelectorAll('.tab-btn').forEach(b => {
      b.classList.remove('border-indigo-500', 'text-indigo-600');
      b.classList.add('border-transparent', 'text-slate-500');
    });
    this.classList.add('border-indigo-500', 'text-indigo-600');
    this.classList.remove('border-transparent', 'text-slate-500');
    
    document.querySelectorAll('.tab-content').forEach(tc => tc.classList.add('hidden'));
    document.getElementById('tab-' + targetTab).classList.remove('hidden');
  });
});
</script>
