<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Permohonan',
  'active' => 'permohonan',
  'breadcrumb' => ['Evaluator', 'Permohonan', 'Rencana']
]) ?>

<div class="bg-white rounded-2xl shadow p-6">
  <div class="flex items-center gap-3 mb-4">
    <a href="<?= site_url('evaluator/permohonan') ?>" class="text-slate-600 hover:text-slate-800">
      <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
        <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
      </svg>
    </a>
    <div class="flex-1">
      <h4 class="text-lg font-semibold">Rencana <?= $status === 'true' ? 'History' : '' ?> 
        <span class="float-right text-indigo-600"><?= esc((string)($tahun ?? '')) ?></span>
      </h4>
      <p class="text-sm text-slate-500">Anda dapat memilih permohonan berdasarkan field di bawah</p>
    </div>
  </div>

  <div class="overflow-x-auto mt-4">
    <table class="min-w-full divide-y divide-slate-200">
      <thead class="bg-slate-50">
        <tr>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">No</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Kode</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Rencana</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Jumlah Aksi</th>
        </tr>
      </thead>
      <tbody class="bg-white divide-y divide-slate-200">
        <?php if (empty($rencana ?? [])): ?>
          <tr><td colspan="4" class="px-4 py-6 text-center text-slate-500">Belum ada data</td></tr>
        <?php else: ?>
          <?php foreach (($rencana ?? []) as $i => $val): ?>
            <tr class="hover:bg-slate-50 cursor-pointer" onclick="window.location.href='<?= site_url('evaluator/permohonan/detail?tahun='.(int)($tahun ?? 0).'&rencana_id='.(int)($val['id'] ?? 0).'&status='.(string)($status ?? '')) ?>'">
              <td class="px-4 py-3 whitespace-nowrap text-sm"><?= $i + 1 ?></td>
              <td class="px-4 py-3 whitespace-nowrap text-sm font-mono"><?= esc((string)($val['kode'] ?? '')) ?></td>
              <td class="px-4 py-3 text-sm"><?= esc((string)($val['aksi'] ?? '')) ?></td>
              <td class="px-4 py-3 whitespace-nowrap text-sm"><?= (int)($val['jumlah'] ?? 0) ?></td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?= view('layouts/dashboard_footer') ?>
