<?php
namespace Modules\User\Controllers;

use App\Controllers\BaseController;
use App\Models\PemantauanModel;

class PkRan extends BaseController
{
    public function index()
    {
        helper('pemantauan');
        $db = db_connect();
        $level1Options = [];
        // Role-based Level1 options (mirror Admin behavior)
        $roleStr = strtolower((string)(session('role') ?? ''));
        $parts = explode(' ', $roleStr);
        $roleTail = trim(($parts && end($parts)) ? end($parts) : '');
        try {
            if ($roleTail === 'kab/kota') {
                $lvl1 = (int)(session('level1') ?? 0);
                if ($lvl1 > 0) {
                    $level1Options = $db->table('level1')->where('id', $lvl1)->get()->getResultArray();
                }
            } elseif ($roleTail === 'provinsi') {
                $level1Options = $db->table('level1')->groupStart()->where('id', 5)->orWhere('id', 6)->groupEnd()->get()->getResultArray();
            } else {
                $level1Options = $db->table('level1')->get()->getResultArray();
            }
        } catch (\Throwable $e) {
            $level1Options = [];
        }

        $qLevel1 = (string)$this->request->getGet('level1_id');
        $qLevel2 = (string)$this->request->getGet('level2_id');
        $qLevel3 = (string)$this->request->getGet('level3_id');

        $rencana = [];
        $bulan = [6,12];
        $m = new PemantauanModel();
        if ($qLevel1 !== '' && ($qLevel2 !== '' || $qLevel3 !== '')) {
            $level1 = $qLevel1 !== '' ? (int)$qLevel1 : null;
            $level2 = $qLevel2 !== '' ? (int)$qLevel2 : null;
            $level3 = $qLevel3 !== '' ? (int)$qLevel3 : null;
            $rencana = $m->getRencana($level1, $level2, $level3);
        } else {
            // default: use user's wilayah scope from session
            $sessL1 = (int)(session('level1') ?? 0);
            $sessL2 = (int)(session('level2') ?? 0);
            $sessL3 = (int)(session('level3') ?? 0);
            $level1 = $sessL1 > 0 ? $sessL1 : null;
            // prefer most specific
            $level3 = $sessL3 > 0 ? $sessL3 : null;
            $level2 = $level3 !== null ? null : ($sessL2 > 0 ? $sessL2 : null);
            $rencana = $m->getRencana($level1, $level2, $level3);
        }

        // Build nested structure like old_app: bidang -> program -> rencana (aksi + indikator[])
        $perjanjian = [];
        if (!empty($rencana)) {
            // Group by bidang, then program
            $byBidang = [];
            foreach ($rencana as $row) {
                $bid = (string)($row['bidang'] ?? '-');
                $prog = (string)($row['program'] ?? '-');
                if (!isset($byBidang[$bid])) $byBidang[$bid] = [];
                if (!isset($byBidang[$bid][$prog])) $byBidang[$bid][$prog] = [];
                $byBidang[$bid][$prog][] = $row;
            }
            foreach ($byBidang as $bidang => $programs) {
                $pgArr = [];
                foreach ($programs as $program => $rows) {
                    $rArr = [];
                    foreach ($rows as $r) {
                        $rArr[] = [
                            'aksi' => $r['aksi'] ?? '-',
                            'indikator' => (array)($r['indikator'] ?? []),
                            'pelaksana_id' => (int)($r['pelaksana_id'] ?? 0),
                        ];
                    }
                    $pgArr[] = [ 'program' => $program, 'rencana' => $rArr ];
                }
                $perjanjian[] = [ 'bidang' => $bidang, 'program' => $pgArr ];
            }
        }

        return view('Modules\\User\\Views\\pkran_index', [
            'title' => 'PK RAN',
            'level1' => $level1Options,
            'rencana' => $rencana,
            'perjanjian' => $perjanjian,
            'bulan' => $bulan,
            'g1' => $qLevel1,
            'g2' => $qLevel2,
            'g3' => $qLevel3,
        ]);
    }

    public function addpkran()
    {
        $this->response->setContentType('application/json');
        $val = (string)$this->request->getPost('val');
        $year = (string)$this->request->getPost('year');
        $indikatorId = (int)$this->request->getPost('indikator_id');
        $month = (int)$this->request->getPost('month');
        $pelaksanaId = (int)$this->request->getPost('pelaksana');
        $id = (int)($this->request->getPost('id') ?? 0);
        $tahun = is_numeric($year) ? (int)$year : (int)($year);
        $db = db_connect();
        $data = [
            'tahun' => $tahun,
            'indikator_id' => $indikatorId,
            'bulan' => $month,
            'keberhasilan' => $val,
            'pelaksana_id' => $pelaksanaId,
            'status' => 0,
            'tanggal' => date('Y-m-d'),
        ];
        if ($id === 0) {
            $db->table('keberhasilan')->insert($data);
            $id = (int)$db->insertID();
        } else {
            // Update only if status == 0 or 3
            $row = $db->table('keberhasilan')->where('id', $id)->get()->getRowArray();
            if ($row && in_array((int)($row['status'] ?? 0), [0,3], true)) {
                $db->table('keberhasilan')->where('id', $id)->update($data);
            }
        }
        return $this->response->setJSON(['status' => true, 'id' => $id]);
    }

    public function setstatus()
    {
        // Emulate old behavior: set status=1 for current user's pelaksana scope
        $db = db_connect();
        $level1 = (int)(session('level1') ?? 0);
        $level2 = session()->has('level3') && (int)session('level3')>0 ? null : (int)(session('level2') ?? 0);
        $level3 = (int)(session('level3') ?? 0);
        $builder = $db->table('pelaksana');
        $builder->select('id');
        if ($level1 > 0) $builder->where('level1_id', $level1);
        if ($level2 !== null) $builder->where('level2_id', (int)$level2);
        if ($level3 > 0) $builder->where('level3_id', $level3);
        $pelaksana = $builder->get()->getResultArray();
        foreach ($pelaksana as $p) {
            $db->table('keberhasilan')
                ->where('status', 0)
                ->where('pelaksana_id', (int)$p['id'])
                ->update(['status' => 1]);
        }
        return $this->response->setJSON(['ok' => true]);
    }
}
