<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Dashboard',
  'active' => 'dashboard',
  'breadcrumb' => ['User','Dashboard']
]) ?>

<div class="px-4 sm:px-6 lg:px-8">
    <style>
      .dash-card{border-radius:16px; overflow:hidden; box-shadow:0 6px 16px rgba(2,8,20,.06); transition:transform .2s ease, box-shadow .2s ease; min-height:120px}
      .dash-card:hover{transform:translateY(-3px); box-shadow:0 12px 24px rgba(2,8,20,.10)}
      .dash-card .value{font-size:32px; line-height:1; font-weight:800; color:#fff}
      .dash-card .label{margin-top:8px; font-size:14px; font-weight:600; letter-spacing:.2px; color:#eef2ff}
      .dash-card .body{padding:18px 20px}
    </style>
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mt-4">
      <?php foreach (($bidang ?? []) as $b): ?>
        <a href="<?= site_url('user/rencana?kategori='.(int)($b['id'] ?? 0)) ?>" class="block">
          <?php $hex = (string)($b['kode_warna'] ?? '#4f46e5'); ?>
          <div class="dash-card" style="background-color: <?= esc($hex) ?>">
            <div class="body">
              <div class="value"><?= (int)($b['jumlah'] ?? 0) ?></div>
              <div class="label"><?= esc((string)($b['bidang'] ?? 'Bidang')) ?></div>
            </div>
          </div>
        </a>
      <?php endforeach; ?>
    </div>

    <div class="bg-white rounded-2xl shadow p-6 mt-8">
      <div id="container"></div>
    </div>
</div>

<?= view('layouts/dashboard_footer') ?>

<script src="https://code.highcharts.com/highcharts.js"></script>
<script type="text/javascript">
  (function(){
    var categories = [];
    <?php try { $maxIdx = (int)(function_exists('year') ? year() : 4); } catch (\Throwable $e) { $maxIdx = 4; } ?>
    <?php for ($i=0; $i <= ($maxIdx ?? 4); $i++): ?>
      categories.push('<?= '202'.$i; ?>');
    <?php endfor; ?>
    var series = <?php echo json_encode($seriesData ?? [], JSON_UNESCAPED_UNICODE); ?>;
    Highcharts.chart('container', {
      chart: { type: 'column' },
      title: { text: 'Grafik Laporan Tiap Tahun' },
      subtitle: { text: 'Menampilkan laporan progress tiap tahun secara beruntun' },
      legend: { align: 'right', verticalAlign: 'middle', layout: 'vertical' },
      xAxis: { categories: categories, labels: { x: -10 } },
      tooltip: { useHTML: true, pointFormat: '<i style="font-size:9px;color:{series.color}">●</i> {series.name}: <b>{point.y}</b><br/>' },
      yAxis: { allowDecimals: false, title: { text: 'Amount' }, labels: { format: '{value}%' } },
      series: series,
      responsive: { rules: [{ condition: { maxWidth: 500 }, chartOptions: { legend: { align: 'center', verticalAlign: 'bottom', layout: 'horizontal' }, yAxis: { labels: { align: 'left', x: 0, y: -5 }, title: { text: null } }, subtitle: { text: null }, credits: { enabled: false } } }] }
    });
  })();
 </script>
