<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Laporan',
  'active' => 'laporan',
  'breadcrumb' => ['User','Laporan']
]) ?>

<div class="bg-white rounded-2xl shadow p-6">
  <h4 class="text-lg font-semibold">Laporan Progress Kerja</h4>
  <p class="text-sm text-slate-500">Anda dapat memilih laporan berdasarkan field di bawah</p>

  <form method="get" class="grid grid-cols-1 md:grid-cols-6 gap-4 mt-5">
    <?php $tahunFull = (string)($tahunFull ?? ''); ?>
    <div class="md:col-span-2">
      <label class="block text-xs text-slate-600 mb-1">Tahun</label>
      <select class="w-full border rounded-lg px-3 py-2" name="tahun" required>
        <option value="">Pilih</option>
        <?php foreach (['2020','2021','2022','2023','2024'] as $t): ?>
          <option value="<?= $t ?>" <?= $tahunFull===$t?'selected':''; ?>><?= $t ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="md:col-span-1 flex items-end">
      <button class="inline-flex items-center gap-2 px-3 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">
        <i data-lucide="search" class="w-4 h-4"></i>
        <span>Cari</span>
      </button>
    </div>
  </form>
</div>

<?php if (!empty($tahunFull)): ?>
  <?php $y = (string)($y ?? ''); ?>
  <div class="bg-white rounded-2xl shadow p-6 mt-6">
    <div class="flex items-center justify-between">
      <div class="font-medium">Laporan Tahun <?= esc($tahunFull) ?></div>
      <a href="<?= site_url('user/laporan/detail?tahun=').$tahunFull; ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50">
        <i data-lucide="file-spreadsheet" class="w-4 h-4"></i>
        <span>Export to Excel</span>
      </a>
    </div>
    <div class="overflow-x-auto mt-4">
      <table class="min-w-full table-auto border rounded pk-table">
        <thead class="bg-slate-50 text-xs">
          <tr>
            <th width="400">Rencana Aksi</th>
            <th width="200">Indikator Keberhasilan</th>
            <th width="200">Ukuran Keberhasilan</th>
            <th>Ukuran Keberhasilan Spesifik (Tahun & Periode)</th>
            <th width="150">Progress</th>
          </tr>
        </thead>
        <tbody class="text-sm">
          <?php $arr_az = range('A','Z'); ?>
          <?php foreach (($perjanjian ?? []) as $o => $pj): ?>
            <tr>
              <th class="px-2 py-1" colspan="5"><?= ($arr_az[$o] ?? ($o+1)).' . '.esc((string)($pj['bidang'] ?? '-')) ?></th>
            </tr>
            <?php foreach (($pj['program'] ?? []) as $a => $pg): ?>
              <tr>
                <th class="px-2 py-1" colspan="5"><?= ($a+1).' . '.esc((string)($pg['program'] ?? '-')) ?></th>
              </tr>
              <?php foreach (($pg['rencana'] ?? []) as $ii => $rnc): ?>
                <?php $inds = (array)($rnc['indikator'] ?? []); ?>
                <tr>
                  <td rowspan="<?= (count($inds) == 1) ? 2 : 4; ?>">
                    <div class="flex"><div class="pr-2"><?= ($ii+1).'.' ?></div><div><?= esc((string)($rnc['aksi'] ?? '-')) ?></div></div>
                  </td>
                  <?php $ind0 = $inds[0] ?? null; ?>
                  <td rowspan="2"><?= esc((string)($ind0['indikator'] ?? '-')) ?></td>
                  <td rowspan="2"><?= esc(spesifikIndikator((int)$y, (int)($ind0['id'] ?? 0))) ?></td>
                  <?php $keb = getKeberhasilanSpesifikLaporan((int)$y,'6',(int)($ind0['id'] ?? 0),(int)($rnc['pelaksana_id'] ?? 0)); $res = empty($keb)?'-':($keb['keberhasilan'] ?? '-'); ?>
                  <td><?= esc($res) ?></td>
                  <td><?= (int)($keb['progress'] ?? 0) ?>%</td>
                </tr>
                <tr>
                  <?php $keb = getKeberhasilanSpesifikLaporan((int)$y,'12',(int)($ind0['id'] ?? 0),(int)($rnc['pelaksana_id'] ?? 0)); $res = empty($keb)?'-':($keb['keberhasilan'] ?? '-'); ?>
                  <td><?= esc($res) ?></td>
                  <td><?= (int)($keb['progress'] ?? 0) ?>%</td>
                </tr>
                <?php for ($f=1; $f < count($inds); $f++): $ind=$inds[$f]; ?>
                  <tr>
                    <td rowspan="2"><?= esc((string)($ind['indikator'] ?? '-')) ?></td>
                    <td rowspan="2"><?= esc(spesifikIndikator((int)$y, (int)($ind['id'] ?? 0))) ?></td>
                    <?php $keb = getKeberhasilanSpesifikLaporan((int)$y,'6',(int)($ind['id'] ?? 0),(int)($rnc['pelaksana_id'] ?? 0)); $res = empty($keb)?'-':($keb['keberhasilan'] ?? '-'); ?>
                    <td><?= esc($res) ?></td>
                    <td><?= (int)($keb['progress'] ?? 0) ?>%</td>
                  </tr>
                  <tr>
                    <?php $keb = getKeberhasilanSpesifikLaporan((int)$y,'12',(int)($ind['id'] ?? 0),(int)($rnc['pelaksana_id'] ?? 0)); $res = empty($keb)?'-':($keb['keberhasilan'] ?? '-'); ?>
                    <td><?= esc($res) ?></td>
                    <td><?= (int)($keb['progress'] ?? 0) ?>%</td>
                  </tr>
                <?php endfor; ?>
              <?php endforeach; ?>
            <?php endforeach; ?>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <style>
    .pk-table{border-collapse:collapse}
    .pk-table td,.pk-table th{vertical-align:top;text-align:left;padding:.5rem .75rem;border:1px solid #e5e7eb}
  </style>
<?php endif; ?>

<?= view('layouts/dashboard_footer') ?>
