<?php
// Props: $label, $value, $accent (tailwind color suffix, e.g., 'indigo', 'emerald')
$accent = $accent ?? 'indigo';
?>
<div class="group bg-white rounded-2xl border border-slate-200 shadow-sm hover:shadow-md transition-shadow duration-200 p-4 flex items-center justify-between">
  <div>
    <div class="text-slate-500 text-xs font-medium tracking-wide mb-1"><?= esc($label ?? '') ?></div>
    <div class="text-[28px] leading-none font-extrabold text-slate-800"><?= esc($value ?? '-') ?></div>
  </div>
  <div class="relative w-12 h-12 rounded-xl bg-<?= esc($accent) ?>-50 flex items-center justify-center ring-1 ring-<?= esc($accent) ?>-100">
    <span class="absolute inset-0 rounded-xl bg-gradient-to-br from-<?= esc($accent) ?>-50 to-transparent opacity-70"></span>
    <span class="relative w-2.5 h-2.5 rounded-full bg-<?= esc($accent) ?>-500 group-hover:scale-110 transition-transform"></span>
  </div>
</div>
