<?php
// Props: $headers (array), $rows (array of arrays)
?>
<div class="overflow-x-auto rounded-lg border border-slate-200">
  <table class="min-w-full divide-y divide-slate-200 text-sm">
    <thead class="bg-slate-50">
      <tr>
        <?php foreach (($headers ?? []) as $h): ?>
          <th class="px-4 py-2 text-left font-medium text-slate-600"><?= esc($h) ?></th>
        <?php endforeach; ?>
      </tr>
    </thead>
    <tbody class="divide-y divide-slate-100 bg-white">
      <?php foreach (($rows ?? []) as $r): ?>
        <tr>
          <?php foreach ($r as $c): ?>
            <td class="px-4 py-2 text-slate-700"><?= esc($c) ?></td>
          <?php endforeach; ?>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
