<?php
namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();
        if (!$session->get('logged_in')) {
            return redirect()->to(base_url('login'));
        }
        // optional: role enforcement if arguments provided
        if ($arguments && count($arguments) > 0) {
            $expected = strtolower($arguments[0]);
            $role = strtolower((string)($session->get('role') ?? ''));
            // allow match if expected keyword appears anywhere in role string
            if ($expected && strpos($role, $expected) === false) {
                // redirect to the correct dashboard based on actual role
                return redirect()->to($this->routeForRole($role));
            }
        }
        return null;
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // no-op
    }

    private function routeForRole(string $role): string
    {
        $r = strtolower(trim($role));
        if (strpos($r, 'admin') !== false) return base_url('admin');
        if (strpos($r, 'evaluator') !== false) return base_url('evaluator');
        if (strpos($r, 'eksekutif') !== false) return base_url('eksekutif');
        return base_url('user');
    }
}
