<?php
namespace App\Models;

use CodeIgniter\Model;
use Throwable;

class BidangModel extends Model
{
    protected $table = 'bidang';
    protected $primaryKey = 'id';
    protected $returnType = 'array';

    public function getAll(): array
    {
        try {
            return $this->db->table('bidang')->get()->getResultArray() ?: [];
        } catch (Throwable $e) {
            return [];
        }
    }

    /**
     * Try to count related records per bidang (kategori) if a likely table/column exists.
     * Returns [bidang_id => count]
     */
    public function countsPerBidang(?array $ids = null): array
    {
        $counts = [];
        try {
            $db = $this->db;
            // choose a likely source table
            // prioritize dashboard_user like old_app helper
            $candidateTables = ['dashboard_user', 'rencana', 'dokumentasi', 'dokumen', 'laporan'];
            $source = null;
            foreach ($candidateTables as $t) {
                try { if ($db->getFieldNames($t)) { $source = $t; break; } } catch (Throwable $e) { /* ignore */ }
            }
            if (!$source) return $counts;

            $fields = $db->getFieldNames($source);
            // likely foreign key column name
            $fkCols = ['bidang_id', 'kategori', 'kategori_id', 'id_bidang'];
            $fk = null;
            foreach ($fkCols as $c) {
                if (in_array($c, $fields, true)) { $fk = $c; break; }
            }
            if (!$fk) return $counts;

            $builder = $db->table($source)->select("$fk, COUNT(*) as cnt")->groupBy($fk);
            if ($ids && count($ids) > 0) {
                $builder->whereIn($fk, $ids);
            }
            foreach ($builder->get()->getResultArray() as $row) {
                $counts[(int) $row[$fk]] = (int) $row['cnt'];
            }
        } catch (Throwable $e) {
            // ignore
        }
        return $counts;
    }
}
