<?php
namespace App\Models;

use CodeIgniter\Model;

class CapaianOutputModel extends Model
{
    protected $DBGroup = 'default';

    public function getCapaian(int $rencana, int $tahun, int $bulan, int $pelaksana, int $indikator): array
    {
        $db = db_connect();
        // Build the inner query similar to old_app getCapaian
        $builder = $db->table('pelaksana');
        $builder->select('level1, level2, level3, tahun, bulan, keberhasilan, SUM(IF(status_eval = 2, dukung.jumlah_output, 0)) as total_output, pelaksana.id as pelaksana_id, wilayah, wlh, st_level2, keberhasilan.id as keb_id, pelaksana.level2_id');
        $builder->join('keberhasilan', 'keberhasilan.pelaksana_id = pelaksana.id', 'right');
        $builder->join('level1', 'level1.id = pelaksana.level1_id', 'left');
        $builder->join('level2', 'level2.id = pelaksana.level2_id', 'left');
        $builder->join('level3', 'level3.id = pelaksana.level3_id', 'left');
        $builder->join('wilayah', 'wilayah.id = level2.wilayah_id', 'left');
        $builder->join('dukung', 'dukung.keberhasilan_id = keberhasilan.id', 'left');
        $builder->where('rencana_id', $rencana);
        $builder->where('indikator_id', $indikator);
        $builder->where(['tahun' => $tahun, 'bulan' => $bulan]);
        $builder->groupStart();
        $builder->where('status_eval !=', 0);
        $builder->groupEnd();
        $builder->groupStart();
        $builder->where('level1.id', $pelaksana);
        $builder->groupEnd();
        $builder->groupBy('rencana_id');
        $builder->groupBy('pelaksana_id');
        $builder->orderBy('total_output', 'DESC');
        $builder->groupBy(['tahun', 'bulan']);
        $subSQL = $builder->getCompiledSelect();

        $out = $db->table("($subSQL) as permohonan")
            ->select('level1, level2, level3, tahun, bulan, keberhasilan, total_output, pelaksana_id, wilayah, wlh, st_level2, keb_id, level2_id')
            ->get()->getResultArray();
        return $out;
    }
}
