<?php
namespace App\Models;

class DashboardAdminModel
{
    public function getLevel1(): array
    {
        try {
            $db = db_connect();
            $builder = $db->table('user u')
                ->select('COUNT(*) as jumlah, l1.level1')
                ->join('level1 l1', 'l1.id = u.level1_id', 'left')
                ->where('u.level1_id IS NOT NULL', null, false)
                ->groupBy('u.level1_id');
            return $builder->get()->getResultArray();
        } catch (\Throwable $e) {
            return [];
        }
    }

    public function getLevel2(?int $level2Id, ?int $wilayahId, string $suffix): array
    {
        try {
            $db = db_connect();
            $builder = $db->table('user u')
                ->select('COUNT(*) as jumlah, l2.level2')
                ->join('level2 l2', 'l2.id = u.level2_id', 'left')
                ->where('u.level2_id IS NOT NULL', null, false);

            if ($suffix === 'kab/kota' && $level2Id) {
                $builder->where('u.level2_id', $level2Id);
            } elseif ($suffix === 'provinsi' && $wilayahId) {
                $builder->where('l2.wilayah_id', $wilayahId);
            }

            $builder->groupBy('u.level2_id')
                ->orderBy('jumlah', 'DESC')
                ->limit(5);
            return $builder->get()->getResultArray();
        } catch (\Throwable $e) {
            return [];
        }
    }

    public function getLevel3(?int $level2Id, ?int $wilayahId, string $suffix): array
    {
        try {
            $db = db_connect();
            $builder = $db->table('user u')
                ->select('COUNT(*) as jumlah, l3.level3')
                ->join('level3 l3', 'l3.id = u.level3_id', 'left')
                ->join('level2 l2', 'l2.id = l3.level2_id', 'left')
                ->where('u.level3_id IS NOT NULL', null, false);

            if ($suffix === 'kab/kota' && $level2Id) {
                $builder->where('u.level2_id', $level2Id);
            } elseif ($suffix === 'provinsi' && $wilayahId) {
                $builder->where('l2.wilayah_id', $wilayahId);
            }

            $builder->groupBy('u.level3_id')
                ->orderBy('jumlah', 'DESC')
                ->limit(12);
            return $builder->get()->getResultArray();
        } catch (\Throwable $e) {
            return [];
        }
    }
}
