<?php
namespace App\Models;

use CodeIgniter\Model;

class PemantauanModel extends Model
{
    protected $DBGroup = 'default';

    private function buildWhere($level1, $level2, $level3): array
    {
        $where = [];
        if ($level1 !== null) { $where['level1_id'] = $level1; }
        if ($level2 !== null) { $where['level2_id'] = $level2; }
        if ($level3 !== null) { $where['level3_id'] = $level3; }
        return $where;
    }

    public function getRencana($level1, $level2, $level3): array
    {
        $db = db_connect();
        $where = $this->buildWhere($level1, $level2, $level3);
        $result = [];
        $data = $db->table('pelaksana')
            ->select('program, aksi, rencana.id, bidang.bidang as bidang, bidang.id as bidang_id, pelaksana.id as pelaksana_id')
            ->join('rencana', 'rencana.id = pelaksana.rencana_id', 'left')
            ->join('program', 'program.id = rencana.program_id', 'left')
            ->join('bidang', 'bidang.id = program.bidang_id', 'left')
            ->where($where)
            ->groupBy('pelaksana.id')
            ->get()->getResultArray();
        foreach ($data as $i => $val) {
            $result[$i] = $val;
            // indikator list by rencana
            $inds = $db->table('indikator')->where('rencana_id', (int)$val['id'])->get()->getResultArray();
            $result[$i]['indikator'] = $inds;
        }
        return $result;
    }
}
