<?php
namespace App\Models;

use CodeIgniter\Model;
use Throwable;

class UserLevelModel extends Model
{
    protected $DBGroup = 'default';

    public function getLevelNames(?int $level1Id, ?int $level2Id, ?int $level3Id): array
    {
        $names = ['level1' => null, 'level2' => null, 'level3' => null];
        try {
            if ($level1Id) {
                $row = $this->db->table('level1')->select('level1')->where('id', $level1Id)->get()->getRowArray();
                $names['level1'] = $row['level1'] ?? null;
            }
            if ($level2Id) {
                $row = $this->db->table('level2')->select('level2')->where('id', $level2Id)->get()->getRowArray();
                $names['level2'] = $row['level2'] ?? null;
            }
            if ($level3Id) {
                $row = $this->db->table('level3')->select('level3')->where('id', $level3Id)->get()->getRowArray();
                $names['level3'] = $row['level3'] ?? null;
            }
        } catch (Throwable $e) {
            // ignore and return whatever collected
        }
        return $names;
    }
}
