<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class Laporan extends BaseController
{
    public function rencana()
    {
        helper(['url']);
        $tahun = (int) ($this->request->getGet('tahun') ?? 0);
        $history = (string) ($this->request->getGet('status') ?? '') === 'true';
        if ($tahun <= 0) {
            return redirect()->to(base_url('admin/periode'));
        }
        $rows = [];
        try {
            $db = db_connect();
            $b = $db->table('keberhasilan k')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                ->select('r.id as rencana_id, r.kode, r.aksi, COUNT(*) as jumlah', false)
                ->where('k.tahun', $tahun)
                ->where('l1.id', 6)
                ->groupBy('r.id, r.kode, r.aksi')
                ->orderBy('jumlah', 'DESC');
            if ($history) {
                // old_app "history" semantics approximated: exclude 0/1 via either status_eval or status
                $b->groupStart()->where('k.status_eval', 2)->orWhere('k.status', '2')->groupEnd();
            } else {
                // non-history path rarely used here; keep approved items
                $b->groupStart()->where('k.status_eval', 2)->orWhere('k.status', '2')->groupEnd();
            }
            $rows = $b->get()->getResultArray();
        } catch (\Throwable $e) {
            $rows = [];
        }
        $payload = [
            'tahun' => $tahun,
            'rows' => $rows,
        ];
        return view('admin/laporan/rencana', $payload);
    }

    public function indikator()
    {
        helper(['url']);
        $tahun = (int) ($this->request->getGet('tahun') ?? 0);
        $rencanaId = (int) ($this->request->getGet('rencana') ?? 0);
        $history = (string) ($this->request->getGet('status') ?? '') === 'true';
        if ($tahun <= 0 || $rencanaId <= 0) {
            return redirect()->to(base_url('admin/periode'));
        }
        $rows = [];
        $rencana = null;
        try {
            $db = db_connect();
            $rencana = $db->table('rencana')->select('id, kode, aksi')->where('id', $rencanaId)->get()->getRowArray();
            $b = $db->table('keberhasilan k')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                ->select('i.id as indikator_id, i.indikator, COUNT(*) as jumlah', false)
                ->where('k.tahun', $tahun)
                ->where('r.id', $rencanaId)
                ->where('l1.id', 6)
                ->groupBy('i.id, i.indikator')
                ->orderBy('jumlah', 'DESC');
            if ($history) {
                $b->groupStart()->where('k.status_eval', 2)->orWhere('k.status', '2')->groupEnd();
            } else {
                $b->groupStart()->where('k.status_eval', 2)->orWhere('k.status', '2')->groupEnd();
            }
            $rows = $b->get()->getResultArray();
        } catch (\Throwable $e) { $rows = []; }
        return view('admin/laporan/indikator', [
            'tahun' => $tahun,
            'rencana' => $rencana,
            'rows' => $rows,
        ]);
    }

    public function detail()
    {
        helper(['url']);
        $tahun = (int) ($this->request->getGet('tahun') ?? 0);
        $rencanaId = (int) ($this->request->getGet('rencana_id') ?? 0);
        $history = (string) ($this->request->getGet('status') ?? '') === 'true';
        if ($tahun <= 0 || $rencanaId <= 0) {
            return redirect()->to(base_url('admin/periode'));
        }
        $rencana = null;
        $bulan6 = [];$bulan12 = [];$ringkasan6 = [];$ringkasan12 = [];$indikatorCount = 0;
        $isDebug = in_array(strtolower((string)($this->request->getGet('debug') ?? '')), ['1','true','yes'], true);
        try {
            $db = db_connect();
            $rencana = $db->table('rencana')->select('id, kode, aksi')->where('id', $rencanaId)->get()->getRowArray();
            // indikator count for this rencana
            $indikatorCount = (int) $db->table('indikator')->where('rencana_id', $rencanaId)->countAllResults();

            // Helper to build generateLaporan-like data for a given bulan snapshot (6 or 12)
            $buildGenerate = function(int $bulan) use ($db, $rencanaId, $tahun) {
                $qb = $db->table('pelaksana p')
                    ->select('l1.level1 as level1, l2.level2 as level2, l3.level3 as level3, w.wilayah as wilayah, k.progress, k.tahun, k.bulan, k.keberhasilan, SUM(IF(k.status_eval = 2, k.progress, 0)) as total_progress, p.id as pelaksana_id, k.id as keb_id', false)
                    ->join('keberhasilan k', 'k.pelaksana_id = p.id', 'right')
                    ->join('indikator i', 'i.id = k.indikator_id', 'left')
                    ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                    ->join('level2 l2', 'l2.id = p.level2_id', 'left')
                    ->join('level3 l3', 'l3.id = p.level3_id', 'left')
                    ->join('wilayah w', 'w.id = l2.wilayah_id', 'left')
                    ->where('i.rencana_id', $rencanaId)
                    ->where(['k.tahun' => $tahun, 'k.bulan' => $bulan])
                    ->groupStart()->where('k.status_eval !=', 0)->groupEnd()
                    // Admin-wide scope: level1 in (1..6)
                    ->whereIn('l1.id', [1,2,3,4,5,6])
                    ->groupBy('p.id')
                    ->orderBy('total_progress', 'DESC')
                    ->groupBy('k.tahun')
                    ->groupBy('k.bulan');
                $sub = $qb->getCompiledSelect();
                $rows = $db->table("($sub) as permohonan")
                    ->select('level1, level2, level3, progress, tahun, bulan, keberhasilan, total_progress, pelaksana_id, keb_id')
                    ->get()->getResultArray();
                return $rows;
            };
            $bulan6 = $buildGenerate(6);
            $bulan12 = $buildGenerate(12);

            // Build ringkasan with total (count of generated rows per group),
            // melapor (subset with total_progress>0), and percentage.
            $buildRingkasan = function(array $generated) {
                $total = [];
                $melapor = [];
                foreach ($generated as $row) {
                    $lvl = (string)($row['level1'] ?? '');
                    if ($lvl==='') continue;
                    $total[$lvl] = ($total[$lvl] ?? 0) + 1;
                    $tp = (int)($row['total_progress'] ?? 0);
                    if ($tp > 0) { $melapor[$lvl] = ($melapor[$lvl] ?? 0) + 1; }
                }
                $keys = array_unique(array_merge(array_keys($total), array_keys($melapor)));
                $out = [];
                foreach ($keys as $k) {
                    $tot = (int)($total[$k] ?? 0);
                    $mel = (int)($melapor[$k] ?? 0);
                    $persen = $tot > 0 ? round($mel * 10000 / $tot) / 100 : 0.0;
                    $out[] = ['level1' => $k, 'total' => $tot, 'melapor' => $mel, 'persen' => $persen];
                }
                usort($out, function($a,$b){ return strcmp($a['level1'], $b['level1']); });
                return $out;
            };
            $ringkasan6 = $buildRingkasan($bulan6);
            $ringkasan12 = $buildRingkasan($bulan12);
        } catch (\Throwable $e) { $rows = []; }
        if ($isDebug) {
            // additional raw counts for troubleshooting
            try {
                $raw6 = $db->table('keberhasilan k')->join('indikator i','i.id=k.indikator_id','left')->where('i.rencana_id',$rencanaId)->where('k.tahun',$tahun)->where('k.bulan',6)->countAllResults();
                $raw12 = $db->table('keberhasilan k')->join('indikator i','i.id=k.indikator_id','left')->where('i.rencana_id',$rencanaId)->where('k.tahun',$tahun)->where('k.bulan',12)->countAllResults();
            } catch (\Throwable $e) { $raw6=0; $raw12=0; }
            return $this->response->setJSON([
                'tahun' => $tahun,
                'rencana_id' => $rencanaId,
                'rencana' => $rencana,
                'counts' => [
                    'bulan6' => is_array($bulan6) ? count($bulan6) : 0,
                    'bulan12' => is_array($bulan12) ? count($bulan12) : 0,
                    'ringkasan6' => is_array($ringkasan6) ? count($ringkasan6) : 0,
                    'ringkasan12' => is_array($ringkasan12) ? count($ringkasan12) : 0,
                    'indikator' => $indikatorCount,
                    'raw_keberhasilan_bulan6' => $raw6,
                    'raw_keberhasilan_bulan12' => $raw12,
                ],
                'sample' => [
                    'bulan6_first' => $bulan6[0] ?? null,
                    'bulan12_first' => $bulan12[0] ?? null,
                    'ringkasan6' => $ringkasan6,
                    'ringkasan12' => $ringkasan12,
                ],
            ]);
        }
        return view('admin/laporan/detail', [
            'tahun' => $tahun,
            'rencana' => $rencana,
            'bulan6' => $bulan6,
            'bulan12' => $bulan12,
            'ringkasan6' => $ringkasan6,
            'ringkasan12' => $ringkasan12,
            'indikator' => $indikatorCount,
        ]);
    }
}
