<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class MasterGroupWilayah extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $rows = [];
        try {
            // Try common column name variants for display
            try {
                $rows = $db->table('group_wilayah')->select('id, nama as name')->orderBy('id','asc')->get()->getResultArray();
            } catch (\Throwable $e1) {
                try {
                    $rows = $db->table('group_wilayah')->select('id, name as name')->orderBy('id','asc')->get()->getResultArray();
                } catch (\Throwable $e2) {
                    $rows = $db->table('group_wilayah')->select('id, group_wilayah as name')->orderBy('id','asc')->get()->getResultArray();
                }
            }
        } catch (\Throwable $e) {
            $rows = [];
        }

        // attach actions HTML (icon-only)
        $rows = array_map(function($r){
            $id = (int)($r['id'] ?? 0);
            $actions = '<div class="inline-flex items-center justify-end gap-1">'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/group_wilayah/show/'.$id).'" title="Detail" aria-label="Detail">'
                .'<i data-lucide="eye" class="w-4 h-4"></i>'
                .'</a>'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/group_wilayah/edit/'.$id).'" title="Edit" aria-label="Edit">'
                .'<i data-lucide="pencil" class="w-4 h-4"></i>'
                .'</a>'
                .'<form method="post" action="'.base_url('admin/master/group_wilayah/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'
                .csrf_field()
                .'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600">'
                .'<i data-lucide="trash-2" class="w-4 h-4"></i>'
                .'</button>'
                .'</form>'
                .'</div>';
            $r['actions'] = $actions;
            return $r;
        }, $rows);

        $data = [
            'title' => 'Master - Group Wilayah',
            'rows'  => $rows,
        ];

        return view('Modules\\Admin\\Views\\master_group_wilayah', $data);
    }

    private function detectNameColumn(): string
    {
        $db = db_connect();
        $fields = $db->getFieldNames('group_wilayah');
        foreach (['nama','name','group_wilayah'] as $c) {
            if (in_array($c, $fields, true)) return $c;
        }
        return 'nama';
    }

    public function create()
    {
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_group_wilayah_form', [
            'title' => 'Tambah Group Wilayah',
            'action' => base_url('admin/master/group_wilayah/store'),
            'value' => '',
            'submitLabel' => 'Simpan',
            'modal' => $isModal,
        ]);
    }

    public function store()
    {
        $name = trim((string)$this->request->getPost('name'));
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        db_connect()->table('group_wilayah')->insert([$this->detectNameColumn() => $name]);
        return redirect()->to(base_url('admin/master/group_wilayah'))->with('success','Group Wilayah ditambahkan');
    }

    public function show(int $id)
    {
        $row = db_connect()->table('group_wilayah')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/group_wilayah'))->with('error','Data tidak ditemukan');
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_group_wilayah_show', [
            'title' => 'Detail Group Wilayah',
            'row' => $row,
            'modal' => $isModal,
        ]);
    }

    public function edit(int $id)
    {
        $row = db_connect()->table('group_wilayah')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/group_wilayah'))->with('error','Data tidak ditemukan');
        $name = $row['nama'] ?? ($row['name'] ?? ($row['group_wilayah'] ?? ''));
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_group_wilayah_form', [
            'title' => 'Edit Group Wilayah',
            'action' => base_url('admin/master/group_wilayah/update/'.$id),
            'value' => $name,
            'submitLabel' => 'Update',
            'modal' => $isModal,
        ]);
    }

    public function update(int $id)
    {
        $name = trim((string)$this->request->getPost('name'));
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        db_connect()->table('group_wilayah')->where('id',$id)->update([$this->detectNameColumn() => $name]);
        return redirect()->to(base_url('admin/master/group_wilayah'))->with('success','Group Wilayah diperbarui');
    }

    public function delete(int $id)
    {
        db_connect()->table('group_wilayah')->where('id',$id)->delete();
        return redirect()->to(base_url('admin/master/group_wilayah'))->with('success','Group Wilayah dihapus');
    }
}
