<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class MasterLevel extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $rows = [];
        try {
            $rows = $db->table('level1')->select('id, level1 as name')->orderBy('id','asc')->get()->getResultArray();
        } catch (\Throwable $e) {
            $rows = [];
        }

        // attach actions HTML (icon-only)
        $rows = array_map(function($r){
            $id = (int)($r['id'] ?? 0);
            $actions = '<div class="inline-flex items-center justify-end gap-1">'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/level/show/'.$id).'" title="Detail" aria-label="Detail">'
                .'<i data-lucide="eye" class="w-4 h-4"></i>'
                .'</a>'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/level/edit/'.$id).'" title="Edit" aria-label="Edit">'
                .'<i data-lucide="pencil" class="w-4 h-4"></i>'
                .'</a>'
                .'<form method="post" action="'.base_url('admin/master/level/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'
                .csrf_field()
                .'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600">'
                .'<i data-lucide="trash-2" class="w-4 h-4"></i>'
                .'</button>'
                .'</form>'
                .'</div>';
            $r['actions'] = $actions;
            return $r;
        }, $rows);

        $data = [
            'title' => 'Master - Level 1',
            'tab' => 'level1',
            'rows' => $rows,
        ];

        return view('Modules\\Admin\\Views\\master_level', $data);
    }

    private function detectNameColumn(): string
    {
        $fields = db_connect()->getFieldNames('level1');
        foreach (['level1','nama','name'] as $c) { if (in_array($c, $fields, true)) return $c; }
        return 'level1';
    }

    public function create()
    {
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_level_form', [
            'title' => 'Tambah Level 1',
            'action' => base_url('admin/master/level/store'),
            'value' => '',
            'submitLabel' => 'Simpan',
            'modal' => $isModal,
        ]);
    }

    public function store()
    {
        $name = trim((string)$this->request->getPost('name'));
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        db_connect()->table('level1')->insert([$this->detectNameColumn() => $name]);
        return redirect()->to(base_url('admin/master/level'))->with('success','Level 1 ditambahkan');
    }

    public function show(int $id)
    {
        $row = db_connect()->table('level1')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/level'))->with('error','Data tidak ditemukan');
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_level_show', [
            'title' => 'Detail Level 1',
            'row' => $row,
            'modal' => $isModal,
        ]);
    }

    public function edit(int $id)
    {
        $row = db_connect()->table('level1')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/level'))->with('error','Data tidak ditemukan');
        $name = $row['level1'] ?? ($row['nama'] ?? ($row['name'] ?? ''));
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_level_form', [
            'title' => 'Edit Level 1',
            'action' => base_url('admin/master/level/update/'.$id),
            'value' => $name,
            'submitLabel' => 'Update',
            'modal' => $isModal,
        ]);
    }

    public function update(int $id)
    {
        $name = trim((string)$this->request->getPost('name'));
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        db_connect()->table('level1')->where('id',$id)->update([$this->detectNameColumn() => $name]);
        return redirect()->to(base_url('admin/master/level'))->with('success','Level 1 diperbarui');
    }

    public function delete(int $id)
    {
        db_connect()->table('level1')->where('id',$id)->delete();
        return redirect()->to(base_url('admin/master/level'))->with('success','Level 1 dihapus');
    }
}
