<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class MasterSatuan extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $rows = [];
        try {
            // Common variants: satuan, nama, name
            try {
                $rows = $db->table('satuan')->select('id, satuan as name')->orderBy('id','asc')->get()->getResultArray();
            } catch (\Throwable $e1) {
                try {
                    $rows = $db->table('satuan')->select('id, nama as name')->orderBy('id','asc')->get()->getResultArray();
                } catch (\Throwable $e2) {
                    $rows = $db->table('satuan')->select('id, name as name')->orderBy('id','asc')->get()->getResultArray();
                }
            }
        } catch (\Throwable $e) {
            $rows = [];
        }

        // attach actions HTML (icon-only)
        $rows = array_map(function($r){
            $id = (int)($r['id'] ?? 0);
            $actions = '<div class="inline-flex items-center justify-end gap-1">'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/satuan/show/'.$id).'" title="Detail" aria-label="Detail">'
                .'<i data-lucide="eye" class="w-4 h-4"></i>'
                .'</a>'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/satuan/edit/'.$id).'" title="Edit" aria-label="Edit">'
                .'<i data-lucide="pencil" class="w-4 h-4"></i>'
                .'</a>'
                .'<form method="post" action="'.base_url('admin/master/satuan/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'
                .csrf_field()
                .'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600">'
                .'<i data-lucide="trash-2" class="w-4 h-4"></i>'
                .'</button>'
                .'</form>'
                .'</div>';
            $r['actions'] = $actions;
            return $r;
        }, $rows);

        $data = [
            'title' => 'Master - Satuan',
            'rows'  => $rows,
        ];

        return view('Modules\\Admin\\Views\\master_satuan', $data);
    }

    private function detectNameColumn(): string
    {
        $fields = db_connect()->getFieldNames('satuan');
        foreach (['satuan','nama','name'] as $c) { if (in_array($c, $fields, true)) return $c; }
        return 'satuan';
    }

    public function create()
    {
        return view('Modules\\Admin\\Views\\master_satuan_form', [
            'title' => 'Tambah Satuan',
            'action' => base_url('admin/master/satuan/store'),
            'value' => '',
            'submitLabel' => 'Simpan',
            'modal' => (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX(),
        ]);
    }

    public function store()
    {
        $name = trim((string)$this->request->getPost('name'));
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        db_connect()->table('satuan')->insert([$this->detectNameColumn() => $name]);
        return redirect()->to(base_url('admin/master/satuan'))->with('success','Satuan ditambahkan');
    }

    public function show(int $id)
    {
        $row = db_connect()->table('satuan')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/satuan'))->with('error','Data tidak ditemukan');
        return view('Modules\\Admin\\Views\\master_satuan_show', [
            'title' => 'Detail Satuan',
            'row' => $row,
            'modal' => (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX(),
        ]);
    }

    public function edit(int $id)
    {
        $row = db_connect()->table('satuan')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/satuan'))->with('error','Data tidak ditemukan');
        $name = $row['satuan'] ?? ($row['nama'] ?? ($row['name'] ?? ''));
        return view('Modules\\Admin\\Views\\master_satuan_form', [
            'title' => 'Edit Satuan',
            'action' => base_url('admin/master/satuan/update/'.$id),
            'value' => $name,
            'submitLabel' => 'Update',
            'modal' => (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX(),
        ]);
    }

    public function update(int $id)
    {
        $name = trim((string)$this->request->getPost('name'));
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        db_connect()->table('satuan')->where('id',$id)->update([$this->detectNameColumn() => $name]);
        return redirect()->to(base_url('admin/master/satuan'))->with('success','Satuan diperbarui');
    }

    public function delete(int $id)
    {
        db_connect()->table('satuan')->where('id',$id)->delete();
        return redirect()->to(base_url('admin/master/satuan'))->with('success','Satuan dihapus');
    }
}
