<?php $isModal = (bool)($modal ?? false); ?>
<?php if (!$isModal): ?>
<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Detail User',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Management User']
]) ?>
  <div class="mb-6">
    <h1 class="text-2xl font-bold">Detail User</h1>
  </div>
  <section class="pb-6">
<?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <div class="grid grid-cols-1 gap-3 text-sm">
      <?php
        // Prefer friendly composed fields first
        $friendly = [];
        $lvl = (string)($row['level'] ?? '');
        if ($lvl !== '') {
          // Replace new lines to <br> if any
          $lvlHtml = nl2br(esc($lvl));
          $friendly[] = ['label' => 'Level', 'value' => $lvlHtml, 'raw' => true];
        }
        $gw = (string)($row['group_wilayah'] ?? '');
        if ($gw !== '') { $friendly[] = ['label' => 'Group Wilayah', 'value' => esc($gw)]; }
        $wil = (string)($row['wilayah'] ?? '');
        if ($wil !== '') { $friendly[] = ['label' => 'Wilayah', 'value' => esc($wil)]; }
      ?>
      <?php foreach ($friendly as $f): ?>
        <div class="flex items-start gap-3">
          <div class="w-40 text-slate-500"><?= esc($f['label']) ?></div>
          <div class="flex-1 text-slate-800 break-all"><?= !empty($f['raw']) ? $f['value'] : esc($f['value']) ?></div>
        </div>
      <?php endforeach; ?>

      <?php foreach (($row ?? []) as $k => $v): ?>
        <?php
          $low = strtolower((string)$k);
          if (in_array($low, ['password','remember_token','token','salt','level','group_wilayah','wilayah','group_wilayah_nama','wilayah_nama','level1','level2','level3'], true)) continue;
        ?>
        <div class="flex items-start gap-3">
          <div class="w-40 text-slate-500 capitalize"><?= esc($k) ?></div>
          <div class="flex-1 text-slate-800 break-all"><?= esc((string)$v) ?></div>
        </div>
      <?php endforeach; ?>
    </div>
    <?php if (!$isModal): ?>
    <div class="flex justify-end gap-2 mt-6">
      <a href="<?= base_url('admin/user') ?>" class="px-4 py-2 rounded-lg border">Kembali</a>
    </div>
    <?php endif; ?>
  </div>

<?php if (!$isModal): ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
<?php endif; ?>
