<?php
// Modal content: Tambah Spesifik Pelaksana
?>
<div class="space-y-4">
  <div class="text-sm font-semibold text-slate-700">Tambah Spesifik Pelaksana</div>
  <form method="post" action="<?= base_url('admin/rencana/pelaksana/store') ?>" class="grid grid-cols-1 sm:grid-cols-3 gap-3">
    <?= csrf_field() ?>
    <input type="hidden" name="rencana_id" value="<?= (int)($rencana_id ?? 0) ?>" />
    <div>
      <label class="block text-sm text-slate-600 mb-1">Level 1 (wajib)</label>
      <select name="level1_id" id="level1" class="w-full border rounded-lg px-3 py-2" data-tom="1" required>
        <option value="">Pilih Level 1</option>
        <?php foreach (($level1 ?? []) as $opt): ?>
          <option value="<?= (int)$opt['id'] ?>"><?= esc((string)$opt['level1']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div>
      <label class="block text-sm text-slate-600 mb-1">Level 2</label>
      <select name="level2_id" id="level2" class="w-full border rounded-lg px-3 py-2" data-tom="1">
        <option value="">Pilih Level 2</option>
      </select>
    </div>
    <div>
      <label class="block text-sm text-slate-600 mb-1">Level 3</label>
      <select name="level3_id" id="level3" class="w-full border rounded-lg px-3 py-2" data-tom="1">
        <option value="">Pilih Level 3</option>
      </select>
    </div>
    <div class="sm:col-span-3 flex justify-end">
      <button type="submit" class="px-3 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">Simpan</button>
    </div>
  </form>

  <!-- Searchable selects via Tom Select (lightweight, no jQuery) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/css/tom-select.css">
  <script src="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/js/tom-select.complete.min.js"></script>
  <script>
    (function(){
      var el1=document.getElementById('level1');
      var el2=document.getElementById('level2');
      var el3=document.getElementById('level3');
      if(!el1||!el2||!el3) return;
      var ts1=new TomSelect(el1,{create:false, allowEmptyOption:true, plugins:{clear_button:{title:'Clear'}}});
      var ts2=new TomSelect(el2,{create:false, allowEmptyOption:true, plugins:{clear_button:{title:'Clear'}}});
      var ts3=new TomSelect(el3,{create:false, allowEmptyOption:true, plugins:{clear_button:{title:'Clear'}}});

      function setTsOptions(ts, items, labelKey){
        ts.clearOptions();
        (items||[]).forEach(function(it){ ts.addOption({value:String(it.id), text:String(it[labelKey]||'')}); });
        ts.refreshOptions(false);
      }

      el1.addEventListener('change', function(){
        ts2.clear(true); ts3.clear(true);
        setTsOptions(ts2, [], 'level2'); setTsOptions(ts3, [], 'level3');
        var id=this.value; if(!id){ return; }
        var u='<?= base_url('admin/rencana/pelaksana/options/level2') ?>?level1_id='+encodeURIComponent(id);
        fetch(u, {headers:{'X-Requested-With':'XMLHttpRequest'}}).then(r=>r.json()).then(function(d){ setTsOptions(ts2, (d&&d.items)||[], 'level2'); });
      });

      el2.addEventListener('change', function(){
        ts3.clear(true);
        setTsOptions(ts3, [], 'level3');
        var id=this.value; if(!id){ return; }
        var u='<?= base_url('admin/rencana/pelaksana/options/level3') ?>?level2_id='+encodeURIComponent(id);
        fetch(u, {headers:{'X-Requested-With':'XMLHttpRequest'}}).then(r=>r.json()).then(function(d){ setTsOptions(ts3, (d&&d.items)||[], 'level3'); });
      });
    })();
  </script>
</div>
