<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <?php $authCssPath = FCPATH.'css/auth.css'; $v = @filemtime($authCssPath) ?: time(); ?>
  <link rel="stylesheet" href="<?= base_url('css/auth.css?v='.$v) ?>">
</head>
<body class="min-h-screen flex items-center justify-center p-4">
  <div class="w-full max-w-md">
    <?php if (session()->getFlashdata('error')): ?>
      <div class="mb-4 bg-red-100 text-red-700 px-4 py-2 rounded"><?= esc(session()->getFlashdata('error')) ?></div>
    <?php endif; ?>
    <div class="bg-white/90 backdrop-blur rounded-xl shadow-xl overflow-hidden">
      <div class="p-6 sm:p-8">
        <h1 class="text-2xl font-semibold text-gray-800">Masuk ke Akun</h1>
        <p class="text-sm text-gray-500 mt-1">Silakan login untuk melanjutkan</p>
        <form method="post" action="<?= base_url('auth/attempt') ?>" class="mt-6 space-y-4">
          <?= csrf_field() ?>
          <div>
            <label class="block text-sm font-medium text-gray-700">Username</label>
            <input name="username" type="text" required class="mt-1 w-full rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500" placeholder="username">
          </div>
          <div>
            <label class="block text-sm font-medium text-gray-700">Password</label>
            <input name="password" type="password" required class="mt-1 w-full rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500" placeholder="••••••••">
          </div>
          <button type="submit" class="w-full inline-flex justify-center items-center rounded-lg bg-indigo-600 text-white py-2.5 font-medium hover:bg-indigo-700 transition">Masuk</button>
        </form>
      </div>
    </div>
    <p class="text-center text-xs text-white/80 mt-4">Powered by CodeIgniter 4 + Tailwind CSS</p>
  </div>
</body>
</html>
