<?php
namespace Modules\Eksekutif\Controllers;

use App\Controllers\BaseController;
use App\Models\ProfileModel;

class Profile extends BaseController
{
    protected ProfileModel $profileModel;

    public function __construct()
    {
        $this->profileModel = new ProfileModel();
        helper(['url', 'form']);
        session();
    }

    public function index()
    {
        $id = (int) (session('id') ?? 0);
        $user = $id ? $this->profileModel->getById($id) : null;
        $data = [
            'title' => 'Profil Eksekutif',
            'user' => $user,
        ];
        return view('Modules\\Eksekutif\\Views\\profile', $data);
    }

    public function update()
    {
        $id = (int) (session('id') ?? 0);
        if (!$id) {
            return redirect()->to(base_url('login'));
        }
        $nama = (string) ($this->request->getPost('nama') ?? '');
        $username = (string) ($this->request->getPost('username') ?? '');
        $no_hp = (string) ($this->request->getPost('no_hp') ?? '');
        $oldPass = (string) ($this->request->getPost('password_lama') ?? '');
        $newPass = (string) ($this->request->getPost('password') ?? '');

        $payload = [
            'nama' => $nama,
            'username' => $username,
            'no_hp' => $no_hp,
        ];

        $ok = $this->profileModel->updateWithPasswordCheck($id, $payload, $oldPass, $newPass);
        if ($ok) {
            // refresh session visible fields
            session()->set([
                'nama' => $nama,
                'username' => $username,
                'no_hp' => $no_hp,
            ]);
            session()->setFlashdata('success', 'Berhasil memperbaharui profil');
        } else {
            session()->setFlashdata('error', 'Gagal memperbaharui profil. Pastikan password lama benar.');
        }
        return redirect()->to(base_url('eksekutif/profile'));
    }
}
