<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Detail Laporan',
  'active' => 'laporan',
  'breadcrumb' => ['Evaluator', 'Laporan', 'Detail']
]) ?>

<div class="bg-white rounded-2xl shadow p-6">
  <div class="flex items-center gap-3 mb-4">
    <a href="<?= site_url('evaluator/laporan/rencana?tahun='.(int)($tahun ?? 0).'&status='.(string)($status ?? '')) ?>" class="text-slate-600 hover:text-slate-800">
      <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
        <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
      </svg>
    </a>
    <div class="flex-1">
      <h4 class="text-lg font-semibold"><?= esc((string)($rencana['aksi'] ?? 'Detail Laporan')) ?></h4>
      <p class="text-sm text-slate-500">Kode: <?= esc((string)($rencana['kode'] ?? '-')) ?> | Tahun: <?= (int)($tahun ?? 0) ?> | Indikator: <?= (int)($indikator ?? 0) ?></p>
    </div>
  </div>

  <!-- Tabs for Bulan 6 and 12 -->
  <div class="mt-4">
    <div class="border-b border-slate-200">
      <nav class="-mb-px flex space-x-8" aria-label="Tabs">
        <button type="button" class="tab-btn border-b-2 border-indigo-500 py-2 px-1 text-indigo-600 font-medium text-sm" data-tab="bulan6">
          Bulan 6
        </button>
        <button type="button" class="tab-btn border-b-2 border-transparent py-2 px-1 text-slate-500 hover:text-slate-700 hover:border-slate-300 font-medium text-sm" data-tab="bulan12">
          Bulan 12
        </button>
      </nav>
    </div>

    <!-- Bulan 6 Tab -->
    <div id="tab-bulan6" class="tab-content mt-4">
      <div class="bg-slate-50 rounded-lg p-4 mb-4">
        <h5 class="font-semibold mb-2">Ringkasan Bulan 6</h5>
        <div class="grid grid-cols-3 gap-4 text-sm">
          <div>Total: <span class="font-bold"><?= (int)($ringkasan6['total'] ?? 0) ?></span></div>
          <div>Disetujui: <span class="font-bold text-green-600"><?= (int)($ringkasan6['approved'] ?? 0) ?></span></div>
          <div>Ditolak: <span class="font-bold text-red-600"><?= (int)($ringkasan6['rejected'] ?? 0) ?></span></div>
        </div>
      </div>

      <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-slate-200">
          <thead class="bg-slate-50">
            <tr>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">No</th>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Pelaksana</th>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Indikator</th>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Keberhasilan</th>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Status</th>
            </tr>
          </thead>
          <tbody class="bg-white divide-y divide-slate-200">
            <?php if (empty($bulan6 ?? [])): ?>
              <tr><td colspan="5" class="px-4 py-6 text-center text-slate-500">Belum ada data</td></tr>
            <?php else: ?>
              <?php foreach (($bulan6 ?? []) as $i => $val): ?>
                <tr class="hover:bg-slate-50">
                  <td class="px-4 py-3 whitespace-nowrap text-sm"><?= $i + 1 ?></td>
                  <td class="px-4 py-3 text-sm">
                    <?php 
                      $pel = array_filter([$val['level1'] ?? null, $val['level2'] ?? null, $val['level3'] ?? null]); 
                      echo esc((string)end($pel));
                    ?>
                  </td>
                  <td class="px-4 py-3 text-sm"><?= esc((string)($val['indikator'] ?? '-')) ?></td>
                  <td class="px-4 py-3 text-sm"><?= esc((string)($val['keberhasilan'] ?? '-')) ?></td>
                  <td class="px-4 py-3 whitespace-nowrap text-sm">
                    <?php
                      $statusMap = [
                        0 => '<span class="px-2 py-1 text-xs rounded bg-slate-100 text-slate-800">Pending</span>',
                        1 => '<span class="px-2 py-1 text-xs rounded bg-blue-100 text-blue-800">Menunggu</span>',
                        2 => '<span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800">Disetujui</span>',
                        3 => '<span class="px-2 py-1 text-xs rounded bg-red-100 text-red-800">Ditolak</span>',
                        4 => '<span class="px-2 py-1 text-xs rounded bg-yellow-100 text-yellow-800">Revisi</span>'
                      ];
                      echo $statusMap[$val['status_eval'] ?? 0] ?? '-';
                    ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Bulan 12 Tab -->
    <div id="tab-bulan12" class="tab-content mt-4 hidden">
      <div class="bg-slate-50 rounded-lg p-4 mb-4">
        <h5 class="font-semibold mb-2">Ringkasan Bulan 12</h5>
        <div class="grid grid-cols-3 gap-4 text-sm">
          <div>Total: <span class="font-bold"><?= (int)($ringkasan12['total'] ?? 0) ?></span></div>
          <div>Disetujui: <span class="font-bold text-green-600"><?= (int)($ringkasan12['approved'] ?? 0) ?></span></div>
          <div>Ditolak: <span class="font-bold text-red-600"><?= (int)($ringkasan12['rejected'] ?? 0) ?></span></div>
        </div>
      </div>

      <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-slate-200">
          <thead class="bg-slate-50">
            <tr>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">No</th>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Pelaksana</th>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Indikator</th>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Keberhasilan</th>
              <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Status</th>
            </tr>
          </thead>
          <tbody class="bg-white divide-y divide-slate-200">
            <?php if (empty($bulan12 ?? [])): ?>
              <tr><td colspan="5" class="px-4 py-6 text-center text-slate-500">Belum ada data</td></tr>
            <?php else: ?>
              <?php foreach (($bulan12 ?? []) as $i => $val): ?>
                <tr class="hover:bg-slate-50">
                  <td class="px-4 py-3 whitespace-nowrap text-sm"><?= $i + 1 ?></td>
                  <td class="px-4 py-3 text-sm">
                    <?php 
                      $pel = array_filter([$val['level1'] ?? null, $val['level2'] ?? null, $val['level3'] ?? null]); 
                      echo esc((string)end($pel));
                    ?>
                  </td>
                  <td class="px-4 py-3 text-sm"><?= esc((string)($val['indikator'] ?? '-')) ?></td>
                  <td class="px-4 py-3 text-sm"><?= esc((string)($val['keberhasilan'] ?? '-')) ?></td>
                  <td class="px-4 py-3 whitespace-nowrap text-sm">
                    <?php
                      $statusMap = [
                        0 => '<span class="px-2 py-1 text-xs rounded bg-slate-100 text-slate-800">Pending</span>',
                        1 => '<span class="px-2 py-1 text-xs rounded bg-blue-100 text-blue-800">Menunggu</span>',
                        2 => '<span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800">Disetujui</span>',
                        3 => '<span class="px-2 py-1 text-xs rounded bg-red-100 text-red-800">Ditolak</span>',
                        4 => '<span class="px-2 py-1 text-xs rounded bg-yellow-100 text-yellow-800">Revisi</span>'
                      ];
                      echo $statusMap[$val['status_eval'] ?? 0] ?? '-';
                    ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?= view('layouts/dashboard_footer') ?>

<script>
document.querySelectorAll('.tab-btn').forEach(btn => {
  btn.addEventListener('click', function() {
    const targetTab = this.dataset.tab;
    document.querySelectorAll('.tab-btn').forEach(b => {
      b.classList.remove('border-indigo-500', 'text-indigo-600');
      b.classList.add('border-transparent', 'text-slate-500');
    });
    this.classList.add('border-indigo-500', 'text-indigo-600');
    this.classList.remove('border-transparent', 'text-slate-500');
    
    document.querySelectorAll('.tab-content').forEach(tc => tc.classList.add('hidden'));
    document.getElementById('tab-' + targetTab).classList.remove('hidden');
  });
});
</script>
