<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Detail Permohonan',
  'active' => 'permohonan',
  'breadcrumb' => ['Evaluator', 'Permohonan', 'Detail']
]) ?>

<div class="bg-white rounded-2xl shadow p-6">
  <div class="flex items-center gap-3 mb-4">
    <a href="<?= site_url('evaluator/permohonan/rencana?tahun='.(int)($tahun ?? 0).'&status='.(string)($status ?? '')) ?>" class="text-slate-600 hover:text-slate-800">
      <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
        <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
      </svg>
    </a>
    <div class="flex-1">
      <h4 class="text-lg font-semibold"><?= esc((string)($rencana['aksi'] ?? 'Detail Permohonan')) ?></h4>
      <p class="text-sm text-slate-500">Kode: <?= esc((string)($rencana['kode'] ?? '-')) ?> | Tahun: <?= (int)($tahun ?? 0) ?></p>
    </div>
  </div>

  <div class="overflow-x-auto mt-4">
    <table id="permohonanTable" class="min-w-full divide-y divide-slate-200 display">
      <thead class="bg-slate-50">
        <tr>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">No</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Pelaksana</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Indikator</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Bulan</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Keberhasilan</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Status</th>
          <?php if ($status !== 'true'): ?>
            <th class="px-4 py-3 text-left text-xs font-medium text-slate-500 uppercase">Aksi</th>
          <?php endif; ?>
        </tr>
      </thead>
      <tbody class="bg-white divide-y divide-slate-200">
        <!-- Data will be loaded via DataTables -->
      </tbody>
    </table>
  </div>
</div>

<?= view('layouts/dashboard_footer') ?>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>

<script>
$(document).ready(function() {
  const table = $('#permohonanTable').DataTable({
    processing: true,
    serverSide: false,
    ajax: {
      url: '<?= site_url('evaluator/permohonan/getAll') ?>',
      type: 'POST',
      data: {
        tahun: <?= (int)($tahun ?? 0) ?>,
        rencana_id: <?= (int)($rencanaId ?? 0) ?>,
        status: '<?= esc((string)($status ?? '')) ?>',
        <?= csrf_token() ?>: '<?= csrf_hash() ?>'
      }
    },
    columns: [
      {
        data: null,
        render: function(data, type, row, meta) {
          return meta.row + 1;
        }
      },
      {
        data: null,
        render: function(data, type, row) {
          const pelaksana = [row.level1, row.level2, row.level3].filter(Boolean);
          return pelaksana[pelaksana.length - 1] || '-';
        }
      },
      { data: 'indikator' },
      {
        data: 'bulan',
        render: function(data) {
          const months = ['', 'Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];
          return months[data] || data;
        }
      },
      { data: 'keberhasilan' },
      {
        data: 'status',
        render: function(data) {
          const statusMap = {
            0: '<span class="px-2 py-1 text-xs rounded bg-slate-100 text-slate-800">Pending</span>',
            1: '<span class="px-2 py-1 text-xs rounded bg-blue-100 text-blue-800">Menunggu</span>',
            2: '<span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800">Disetujui</span>',
            3: '<span class="px-2 py-1 text-xs rounded bg-red-100 text-red-800">Ditolak</span>',
            4: '<span class="px-2 py-1 text-xs rounded bg-yellow-100 text-yellow-800">Revisi</span>'
          };
          return statusMap[data] || '-';
        }
      },
      <?php if ($status !== 'true'): ?>
      {
        data: null,
        render: function(data, type, row) {
          return `
            <button class="btn-approve px-2 py-1 text-xs bg-green-600 text-white rounded hover:bg-green-700" data-id="${row.id}">Setujui</button>
            <button class="btn-reject px-2 py-1 text-xs bg-red-600 text-white rounded hover:bg-red-700" data-id="${row.id}">Tolak</button>
          `;
        }
      }
      <?php endif; ?>
    ]
  });

  // Handle approve/reject buttons
  <?php if ($status !== 'true'): ?>
  $('#permohonanTable').on('click', '.btn-approve', function() {
    const id = $(this).data('id');
    if (confirm('Setujui permohonan ini?')) {
      changeStatus(id, 2);
    }
  });

  $('#permohonanTable').on('click', '.btn-reject', function() {
    const id = $(this).data('id');
    const catatan = prompt('Masukkan catatan penolakan (opsional):');
    changeStatus(id, 3, catatan || '');
  });

  function changeStatus(id, status, catatan = '') {
    $.ajax({
      url: '<?= site_url('evaluator/permohonan/changeStatus') ?>',
      type: 'POST',
      data: {
        id: id,
        status: status,
        catatan: catatan,
        <?= csrf_token() ?>: '<?= csrf_hash() ?>'
      },
      success: function(response) {
        if (response.status) {
          table.ajax.reload();
          alert('Status berhasil diubah');
        } else {
          alert('Gagal mengubah status');
        }
      },
      error: function() {
        alert('Terjadi kesalahan');
      }
    });
  }
  <?php endif; ?>
});
</script>
