<?php
namespace Modules\User\Controllers;

use App\Controllers\BaseController;
use App\Models\PemantauanModel;

class Laporan extends BaseController
{
    public function index()
    {
        helper('pemantauan');
        $tahunFull = (string)$this->request->getGet('tahun'); // e.g. 2020..2024
        $y = '';
        if ($tahunFull !== '' && strpos($tahunFull, '202') === 0) {
            $y = str_replace('202', '', $tahunFull);
        }

        $m = new PemantauanModel();
        $sessL1 = (int)(session('level1') ?? 0);
        $sessL2 = (int)(session('level2') ?? 0);
        $sessL3 = (int)(session('level3') ?? 0);
        $level1 = $sessL1 > 0 ? $sessL1 : null;
        $level3 = $sessL3 > 0 ? $sessL3 : null;
        $level2 = $level3 !== null ? null : ($sessL2 > 0 ? $sessL2 : null);
        $rencana = $m->getRencana($level1, $level2, $level3);

        // Build nested perjanjian like PKRAN
        $perjanjian = [];
        if (!empty($rencana)) {
            $byBidang = [];
            foreach ($rencana as $row) {
                $bid = (string)($row['bidang'] ?? '-');
                $prog = (string)($row['program'] ?? '-');
                if (!isset($byBidang[$bid])) $byBidang[$bid] = [];
                if (!isset($byBidang[$bid][$prog])) $byBidang[$bid][$prog] = [];
                $byBidang[$bid][$prog][] = $row;
            }
            foreach ($byBidang as $bidang => $programs) {
                $pgArr = [];
                foreach ($programs as $program => $rows) {
                    $rArr = [];
                    foreach ($rows as $r) {
                        $rArr[] = [
                            'aksi' => $r['aksi'] ?? '-',
                            'indikator' => (array)($r['indikator'] ?? []),
                            'pelaksana_id' => (int)($r['pelaksana_id'] ?? 0),
                        ];
                    }
                    $pgArr[] = [ 'program' => $program, 'rencana' => $rArr ];
                }
                $perjanjian[] = [ 'bidang' => $bidang, 'program' => $pgArr ];
            }
        }

        return view('Modules\\User\\Views\\laporan_index', [
            'title' => 'Laporan',
            'perjanjian' => $perjanjian,
            'tahunFull' => $tahunFull,
            'y' => $y,
        ]);
    }

    public function detail()
    {
        helper('pemantauan');
        $tahunFull = (string)$this->request->getGet('tahun');
        if ($tahunFull === '' || strpos($tahunFull, '202') !== 0) {
            return redirect()->to(site_url('user/laporan'));
        }
        $y = str_replace('202', '', $tahunFull);

        $m = new PemantauanModel();
        $sessL1 = (int)(session('level1') ?? 0);
        $sessL2 = (int)(session('level2') ?? 0);
        $sessL3 = (int)(session('level3') ?? 0);
        $level1 = $sessL1 > 0 ? $sessL1 : null;
        $level3 = $sessL3 > 0 ? $sessL3 : null;
        $level2 = $level3 !== null ? null : ($sessL2 > 0 ? $sessL2 : null);
        $rencana = $m->getRencana($level1, $level2, $level3);

        // Build nested perjanjian
        $perjanjian = [];
        if (!empty($rencana)) {
            $byBidang = [];
            foreach ($rencana as $row) {
                $bid = (string)($row['bidang'] ?? '-');
                $prog = (string)($row['program'] ?? '-');
                if (!isset($byBidang[$bid])) $byBidang[$bid] = [];
                if (!isset($byBidang[$bid][$prog])) $byBidang[$bid][$prog] = [];
                $byBidang[$bid][$prog][] = $row;
            }
            foreach ($byBidang as $bidang => $programs) {
                $pgArr = [];
                foreach ($programs as $program => $rows) {
                    $rArr = [];
                    foreach ($rows as $r) {
                        $rArr[] = [
                            'aksi' => $r['aksi'] ?? '-',
                            'indikator' => (array)($r['indikator'] ?? []),
                            'pelaksana_id' => (int)($r['pelaksana_id'] ?? 0),
                        ];
                    }
                    $pgArr[] = [ 'program' => $program, 'rencana' => $rArr ];
                }
                $perjanjian[] = [ 'bidang' => $bidang, 'program' => $pgArr ];
            }
        }

        // Set headers for Excel export
        $this->response->setHeader('Content-Type', 'application/vnd-ms-excel');
        $this->response->setHeader('Content-Disposition', 'attachment; filename=Laporan-Inpres-Tahun-'.$tahunFull.'.xls');

        return view('Modules\\User\\Views\\laporan_report', [
            'perjanjian' => $perjanjian,
            'tahunFull' => $tahunFull,
            'y' => $y,
        ]);
    }
}
