<?php
namespace Modules\User\Controllers;

use App\Controllers\BaseController;
use App\Models\PemantauanModel;

class Rencana extends BaseController
{
    public function index()
    {
        helper('pemantauan');
        $db = db_connect();

        // Kategori (bidang) filter seperti old_app ?kategori=<bidang_id>
        $kategori = (string)$this->request->getGet('kategori');

        // Ambil rencana berdasarkan scope wilayah user (default) sama seperti PkRan
        $m = new PemantauanModel();
        $sessL1 = (int)(session('level1') ?? 0);
        $sessL2 = (int)(session('level2') ?? 0);
        $sessL3 = (int)(session('level3') ?? 0);
        $level1 = $sessL1 > 0 ? $sessL1 : null;
        $level3 = $sessL3 > 0 ? $sessL3 : null;
        $level2 = $level3 !== null ? null : ($sessL2 > 0 ? $sessL2 : null);
        $items = $m->getRencana($level1, $level2, $level3);

        // Filter by bidang if kategori provided
        if ($kategori !== '') {
            $bid = (int)$kategori;
            $items = array_values(array_filter($items, static function($x) use ($bid) {
                return (int)($x['bidang_id'] ?? 0) === $bid;
            }));
        }

        // List bidang cards (like old: dashboard->getBidang())
        $bidangList = [];
        try {
            $bidangList = $db->table('bidang')->select('id,bidang')->get()->getResultArray();
            // Optional color key not present; keep simple
            foreach ($bidangList as &$b) { $b['warna'] = 'bg-indigo-600'; }
        } catch (\Throwable $e) { $bidangList = []; }

        $bulan = [6,12];

        return view('Modules\\User\\Views\\rencana_index', [
            'title' => 'Pelaporan Aksi',
            'bidang' => $bidangList,
            'rencana' => $items,
            'bulan' => $bulan,
            'kategori' => $kategori,
        ]);
    }

    public function setProgres()
    {
        $db = db_connect();
        $tahunIdx = (string)$this->request->getPost('tahun'); // e.g. 0..4
        $data = [
            'progress' => (int)$this->request->getPost('progres'),
            'tanggal_progres' => date('Y-m-d'),
            'status_eval' => null,
        ];
        $where = [
            'tahun' => (int)('202' . $tahunIdx),
            'indikator_id' => (int)$this->request->getPost('indikator_id'),
            'bulan' => (int)$this->request->getPost('bulan'),
            'pelaksana_id' => (int)$this->request->getPost('pelaksana_id'),
        ];
        try {
            $db->table('keberhasilan')->where($where)->update($data);
        } catch (\Throwable $e) {
            // ignore
        }
        return redirect()->to(site_url('user/rencana'));
    }
}
