<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Pelaporan Aksi',
  'active' => 'pelaporanaksi',
  'breadcrumb' => ['User','Pelaporan Aksi']
]) ?>

<div class="bg-white rounded-2xl shadow p-6">
  <h4 class="text-lg font-semibold">Rencana Aksi</h4>
  <p class="text-sm text-slate-500">Harus memberikan laporan progres rencana setiap 6 bulan sekali</p>

  <div class="grid grid-cols-2 md:grid-cols-4 gap-3 mt-5">
    <?php foreach (($bidang ?? []) as $b): ?>
      <a class="block rounded-lg border hover:bg-slate-50 px-4 py-3 <?php if ((string)($kategori??'')===(string)($b['id']??'')) echo 'ring-2 ring-indigo-500'; ?>" href="<?= site_url('user/rencana?kategori='.(int)$b['id']) ?>">
        <div class="text-sm text-slate-600">Bidang</div>
        <div class="font-semibold"><?= esc((string)$b['bidang']) ?></div>
      </a>
    <?php endforeach; ?>
  </div>
</div>

<?php if (!empty($rencana)): ?>
  <div class="bg-white rounded-2xl shadow p-6 mt-6">
    <div class="flex border-b text-sm">
      <?php foreach (($rencana ?? []) as $idx => $val): ?>
        <button type="button" data-pane="r<?= $idx ?>" class="rn-tab px-4 py-2 border-b-2 <?= $idx===0?'border-indigo-600 text-indigo-600':'border-transparent text-slate-600' ?>">Rencana Aksi <?= $idx+1 ?></button>
      <?php endforeach; ?>
    </div>

    <?php foreach (($rencana ?? []) as $idx => $val): ?>
      <div id="r<?= $idx ?>" class="rn-pane <?= $idx!==0?'hidden':'' ?> pt-4">
        <div class="space-y-3">
          <div class="flex gap-3"><div class="w-40 font-semibold">Monitor</div><div>: Inpres No 2 Tahun 2020 Tentang RAN P4GN 2020-2024</div></div>
          <div class="flex gap-3"><div class="w-40 font-semibold">Bidang</div><div>: <?= esc((string)($val['bidang'] ?? '-')) ?></div></div>
          <div class="flex gap-3"><div class="w-40 font-semibold">Program</div><div>: <?= esc((string)($val['program'] ?? '-')) ?></div></div>
          <div class="flex gap-3"><div class="w-40 font-semibold">Aksi Rencana</div><div>: <?= esc((string)($val['aksi'] ?? '-')) ?></div></div>
          <div class="flex gap-3"><div class="w-40 font-semibold">Indikator Keberhasilan</div>
            <div>:
              <?php $inds = (array)($val['indikator'] ?? []); if (count($inds)<=1): ?>
                <?= esc((string)($inds[0]['indikator'] ?? '-')) ?>
              <?php else: foreach ($inds as $vv): ?>
                <div>- <?= esc((string)($vv['indikator'] ?? '')) ?></div>
              <?php endforeach; endif; ?>
            </div>
          </div>
        </div>

        <div class="mt-5">
          <div class="flex border-b text-sm">
            <?php for ($y=0; $y<=yearRencana(); $y++): ?>
              <button type="button" data-year="r<?= $idx ?>-y<?= $y ?>" class="rn-year px-4 py-2 border-b-2 <?= $y===0?'border-indigo-600 text-indigo-600':'border-transparent text-slate-600' ?>"><?= '202'.$y ?></button>
            <?php endfor; ?>
          </div>
          <?php for ($y=0; $y<=yearRencana(); $y++): ?>
            <div id="r<?= $idx ?>-y<?= $y ?>" class="rn-year-pane <?= $y!==0?'hidden':'' ?> pt-4">
              <?php $inds = (array)($val['indikator'] ?? []); ?>
              <?php if (!empty($inds) && cekKeberhasilan($y, (int)($val['pelaksana_id'] ?? 0))): ?>
                <?php foreach ($inds as $idk): ?>
                  <div class="border-t pt-4 mt-4">
                    <div class="flex gap-3"><div class="w-44 text-sm text-slate-600">Indikator Keberhasilan</div><div class="font-medium">: <?= esc((string)($idk['indikator'] ?? '')) ?></div></div>
                    <div class="flex gap-3 mt-1"><div class="w-44 text-sm text-slate-600">Ukuran Keberhasilan</div><div>: <?= esc(spesifikIndikator($y, (int)($idk['id'] ?? 0))) ?></div></div>

                    <div class="overflow-x-auto mt-3">
                      <table class="min-w-full table-auto border rounded pk-table">
                        <thead class="bg-slate-50 text-xs">
                          <tr>
                            <th width="90">Periode</th>
                            <th width="250">Target Spesifik</th>
                            <th width="250">Capaian (%)</th>
                            <th width="140">Data Dukung</th>
                            <th width="100" class="text-center">Status</th>
                            <th>Catatan Evaluator</th>
                          </tr>
                        </thead>
                        <tbody class="text-sm">
                          <?php foreach (($bulan ?? [6,12]) as $bln): ?>
                            <?php $getKeb = getKeberhasilanSpesifikRencana($y, (int)$bln, (int)($idk['id'] ?? 0), (int)($val['pelaksana_id'] ?? 0)) ?? '-'; ?>
                            <?php $result = getArrayKeberhasilan($y, (int)$bln, (int)($idk['id'] ?? 0), (int)($val['pelaksana_id'] ?? 0)); ?>
                            <tr>
                              <td><?= 'Bulan '.(int)$bln; ?></td>
                              <td><?= esc($getKeb) ?></td>
                              <td>
                                <?php if (batas((int)$bln, $y, true) == false): ?>
                                  <?php if (batasRevisi((int)$bln, $y, true) == true && (int)($result['status_eval'] ?? 0) === 3): ?>
                                    <form method="post" action="<?= site_url('user/rencana/setProgres') ?>" onsubmit="return confirm('Apakah Yakin ?')">
                                      <div class="flex items-center gap-2">
                                        <input type="hidden" name="tahun" value="<?= $y; ?>">
                                        <input type="hidden" name="bulan" value="<?= (int)$bln; ?>">
                                        <input type="hidden" name="indikator_id" value="<?= (int)($idk['id'] ?? 0) ?>">
                                        <input type="hidden" name="pelaksana_id" value="<?= (int)($val['pelaksana_id'] ?? 0); ?>">
                                        <input type="number" required min="1" max="100" value="<?= (int)($result['progress'] ?? 0) ?>" name="progres" class="w-32 border rounded px-2 py-1" placeholder="100">
                                        <button class="px-3 py-1 rounded bg-indigo-600 text-white">Go</button>
                                      </div>
                                    </form>
                                  <?php else: ?>
                                    <?php if ((int)($result['progress'] ?? 0) !== 0): ?>
                                      <div class="w-48 bg-slate-100 rounded mt-1">
                                        <div class="h-3 bg-indigo-500 rounded" style="width: <?= (int)($result['progress'] ?? 0) ?>%"></div>
                                      </div>
                                      <div class="text-xs text-slate-600 mt-1"><?= (int)($result['progress'] ?? 0) ?>%</div>
                                    <?php endif; ?>
                                  <?php endif; ?>
                                <?php else: ?>
                                  <?php if ($getKeb !== '-') : ?>
                                    <?php if ((int)($result['status_eval'] ?? 0) !== 2): ?>
                                      <form method="post" action="<?= site_url('user/rencana/setProgres') ?>" onsubmit="return confirm('Apakah Yakin ?')">
                                        <div class="flex items-center gap-2">
                                          <input type="hidden" name="tahun" value="<?= $y; ?>">
                                          <input type="hidden" name="bulan" value="<?= (int)$bln; ?>">
                                          <input type="hidden" name="indikator_id" value="<?= (int)($idk['id'] ?? 0) ?>">
                                          <input type="hidden" name="pelaksana_id" value="<?= (int)($val['pelaksana_id'] ?? 0); ?>">
                                          <input type="number" required min="1" max="100" value="<?= (int)($result['progress'] ?? 0) ?>" name="progres" class="w-32 border rounded px-2 py-1" placeholder="100">
                                          <button class="px-3 py-1 rounded bg-indigo-600 text-white">Go</button>
                                        </div>
                                      </form>
                                    <?php else: ?>
                                      <div class="w-48 bg-slate-100 rounded mt-1">
                                        <div class="h-3 bg-indigo-500 rounded" style="width: <?= (int)($result['progress'] ?? 0) ?>%"></div>
                                      </div>
                                      <div class="text-xs text-slate-600 mt-1"><?= (int)($result['progress'] ?? 0) ?>%</div>
                                    <?php endif; ?>
                                  <?php else: ?>
                                    -
                                  <?php endif; ?>
                                <?php endif; ?>
                              </td>
                              <td><?= statusForm(($result['id'] ?? null), batas((int)$bln, $y)); ?></td>
                              <td class="text-center"><?= evaluatorStatus(($result['status_eval'] ?? null)); ?></td>
                              <td>
                                <?php
                                  try {
                                    $catatans = db_connect()->table('catatan')->where('keberhasilan_id', (int)($result['id'] ?? 0))->get()->getResultArray();
                                  } catch (\Throwable $e) { $catatans = []; }
                                ?>
                                <ul class="list-disc pl-5">
                                  <?php if (!empty($result['catatan_eval'])): ?>
                                    <li><?= esc((string)$result['catatan_eval']) ?></li>
                                  <?php endif; ?>
                                  <?php foreach (($catatans ?? []) as $ct): ?>
                                    <li><?= esc((string)($ct['catatan_eval'] ?? '')) ?></li>
                                  <?php endforeach; ?>
                                </ul>
                              </td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                <?php endforeach; ?>
              <?php else: ?>
                <div class="text-center text-slate-500 py-10">Tidak ada target spesifik</div>
              <?php endif; ?>
            </div>
          <?php endfor; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <style>
    .pk-table{border-collapse:collapse}
    .pk-table td,.pk-table th{vertical-align:top;text-align:left;padding:.5rem .75rem;border:1px solid #e5e7eb}
  </style>
  <script>
    (function(){
      document.querySelectorAll('.rn-tab').forEach(function(btn){
        btn.addEventListener('click', function(){
          var id = this.getAttribute('data-pane');
          if (!id) return;
          document.querySelectorAll('.rn-pane').forEach(function(p){ p.classList.add('hidden'); });
          document.getElementById(id).classList.remove('hidden');
          document.querySelectorAll('.rn-tab').forEach(function(b){ b.classList.remove('border-indigo-600','text-indigo-600'); b.classList.add('border-transparent','text-slate-600'); });
          this.classList.add('border-indigo-600','text-indigo-600'); this.classList.remove('border-transparent','text-slate-600');
        });
      });
      document.querySelectorAll('.rn-year').forEach(function(btn){
        btn.addEventListener('click', function(){
          var id = this.getAttribute('data-year');
          if (!id) return;
          var group = id.split('-')[0];
          document.querySelectorAll('[id^="'+group+'-y"]').forEach(function(p){ p.classList.add('hidden'); });
          document.getElementById(id).classList.remove('hidden');
          var parent = this.parentElement; if (!parent) return;
          parent.querySelectorAll('.rn-year').forEach(function(b){ b.classList.remove('border-indigo-600','text-indigo-600'); b.classList.add('border-transparent','text-slate-600'); });
          this.classList.add('border-indigo-600','text-indigo-600'); this.classList.remove('border-transparent','text-slate-600');
        });
      });
    })();
  </script>
<?php endif; ?>

<?= view('layouts/dashboard_footer') ?>
