<?= view('layouts/dashboard_header', [
  'title' => 'Laporan - Detail',
  'active' => 'laporan',
  'breadcrumb' => ['Admin','Laporan','Detail']
]) ?>

<div class="bg-white rounded-2xl shadow p-6 mt-6">
  <?php
    $backHref = base_url('admin/laporan/rencana').'?tahun='.urlencode((string)$tahun).'&status=true';
    $prefixBase = (strpos((string)current_url(), '/eksekutif/') !== false) ? 'eksekutif' : 'admin';
    $backHref = base_url($prefixBase.'/laporan/rencana').'?tahun='.(int)($tahun ?? 0).'&status=true';
    echo '<div class="flex items-center gap-2 mb-2">'
        . '<a href="'.esc($backHref).'" class="inline-flex items-center justify-center w-8 h-8 rounded-md border border-slate-200 text-slate-600 hover:bg-slate-50" title="Kembali">'
        . '<svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"/><path d="M20 12H9"/></svg>'
        . '</a>'
        . '<h2 class="text-lg font-semibold flex-1">Permohonan History</h2>'
        . '<div class="text-sm font-semibold text-slate-500">'.esc($rencana['kode'] ?? '').'</div>'
        . '</div>';
    // Rencana description text
    echo '<p class="text-sm text-slate-700 mb-3">'.esc($rencana['aksi'] ?? '').'</p>';
    // Info list
    echo '<div class="grid grid-cols-1 sm:grid-cols-2 gap-3 mb-4">'
        . '<div><div class="text-xs text-slate-500">Tahun:</div><div class="text-sm font-medium text-slate-800">'.esc((string)$tahun).'</div></div>'
        . '<div><div class="text-xs text-slate-500">Rencana:</div><div class="text-sm font-medium text-slate-800">'.esc($rencana['aksi'] ?? '').'</div></div>'
        . '</div>';
    // Tabs: Ringkasan Laporan / Laporan Lengkap
    echo '<div class="flex items-center gap-2 mb-4">'
        . '<button id="tab_ringkasan" class="px-3 py-1.5 rounded-md text-sm bg-sky-600 text-white hover:bg-sky-700">Ringkasan Laporan</button>'
        . '<button id="tab_lengkap" class="px-3 py-1.5 rounded-md text-sm bg-white text-slate-700 border border-slate-300 hover:bg-slate-50">Laporan Lengkap</button>'
        . '</div>';

    // Ringkasan section with sub-tabs Bulan 6 / Bulan 12
    echo '<div id="panel_ringkasan">';
      echo '<div class="flex items-center gap-3 mb-3">'
         . '<button id="sub_r6" class="px-3 py-1 rounded border border-slate-300 text-sm bg-white text-slate-700 hover:bg-slate-50">Bulan 6</button>'
         . '<button id="sub_r12" class="px-3 py-1 rounded text-sm bg-sky-600 text-white hover:bg-sky-700">Bulan 12</button>'
         . '</div>';
      $hdrSum = [ ['key'=>'no','label'=>'No','noSort'=>true], ['key'=>'level1','label'=>'Group'], ['key'=>'total','label'=>'Total','align'=>'right'], ['key'=>'melapor','label'=>'Melapor','align'=>'right'], ['key'=>'persentase','label'=>'Persentase','align'=>'right'] ];
      $fmtRing = function($rows){ return array_map(function($v){ return [
        'level1'=>(string)($v['level1']??'-'),
        'total'=> (string)($v['total'] ?? '0'),
        'melapor'=> (string)($v['melapor'] ?? '0'),
        'persentase'=> number_format((float)($v['persen'] ?? 0), 2).'%',
      ]; }, $rows ?? []); };
      echo '<div id="panel_ring6" style="display:none">';
      echo view('components/data-table', [ 'id'=>'dt_ringkasan6', 'headers'=>$hdrSum, 'rows'=>$fmtRing($ringkasan6), 'pageSize'=>10 ]);
      echo '</div>';
      echo '<div id="panel_ring12" style="">';
      echo view('components/data-table', [ 'id'=>'dt_ringkasan12', 'headers'=>$hdrSum, 'rows'=>$fmtRing($ringkasan12), 'pageSize'=>10 ]);
      echo '</div>';
    echo '</div>';

    // Lengkap section with sub-tabs Bulan 6 / Bulan 12
    echo '<div id="panel_lengkap" style="display:none">';
      echo '<div class="flex items-center gap-3 mb-3">'
         . '<button id="sub_l6" class="px-3 py-1 rounded border border-slate-300 text-sm bg-white text-slate-700 hover:bg-slate-50">Bulan 6</button>'
         . '<button id="sub_l12" class="px-3 py-1 rounded text-sm bg-sky-600 text-white hover:bg-sky-700">Bulan 12</button>'
         . '</div>';
      $hdrFull = [
        ['key'=>'no','label'=>'No','noSort'=>true],
        ['key'=>'group','label'=>'Group'],
        ['key'=>'instansi','label'=>'Instansi'],
        ['key'=>'satuan_kerja','label'=>'Satuan Kerja'],
        ['key'=>'wilayah','label'=>'Wilayah'],
        ['key'=>'capaian','label'=>'Capaian','align'=>'right'],
        ['key'=>'opsi','label'=>'Opsi','noSort'=>true],
      ];
      $mapFull = function($arr, $tahun, $indikator) use ($rencana){
        return array_map(function($v) use ($tahun, $indikator, $rencana){
          $tp = (float)($v['total_progress'] ?? $v['progress'] ?? 0);
          if ($tp >= 300 && (int)$indikator === 2) {
            $total = 200;
          } elseif ($tp >= 200 && (int)$indikator === 1) {
            $total = 100;
          } else {
            $total = $tp;
          }
          $pct = ($tp != 0 && (int)$indikator > 0) ? number_format($total / (int)$indikator, 2).'%' : '0%';
          $rid = (string)($rencana['id'] ?? '');
          $detailHref = base_url('eksekutif/progres/detail').'?rencana_id='.urlencode($rid).'&pelaksana_id='.urlencode((string)($v['pelaksana_id'] ?? '')).'&keb_id='.urlencode((string)($v['keb_id'] ?? '')).'&periode='.urlencode((string)$tahun);
          return [
            'group' => (string)($v['level1'] ?? '-'),
            'instansi' => (string)($v['level2'] ?? '-'),
            'satuan_kerja' => (string)($v['level3'] ?? '-'),
            'wilayah' => (string)($v['wilayah'] ?? '-'),
            'capaian' => $pct,
            'opsi' => '<a class="inline-flex items-center gap-1 px-2 py-1 rounded border border-slate-300 text-slate-700 hover:bg-slate-50" target="_blank" href="'.esc($detailHref).'"><svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><line x1="22" y1="12" x2="18" y2="12"/><line x1="6" y1="12" x2="2" y2="12"/><line x1="12" y1="6" x2="12" y2="2"/><line x1="12" y1="22" x2="12" y2="18"/></svg> Detail</a>',
          ];
        }, $arr ?? []);
      };
      echo '<div id="panel_len6" style="display:none">';
      $rowsLen6 = $mapFull($bulan6, (string)$tahun.'_6', $indikator ?? 0);
      echo view('components/data-table', [ 'id'=>'dt_lengkap6', 'headers'=>array_map(function($h){ $k=$h['key']??''; if($k==='opsi'){ $h['raw']=true; } return $h; }, $hdrFull), 'rows'=>$rowsLen6, 'pageSize'=>10 ]);
      echo '</div>';
      echo '<div id="panel_len12" style="">';
      $rowsLen12 = $mapFull($bulan12, (string)$tahun.'_12', $indikator ?? 0);
      echo view('components/data-table', [ 'id'=>'dt_lengkap12', 'headers'=>array_map(function($h){ $k=$h['key']??''; if($k==='opsi'){ $h['raw']=true; } return $h; }, $hdrFull), 'rows'=>$rowsLen12, 'pageSize'=>10 ]);
      echo '</div>';
    echo '</div>';

    ?>
    <script>
      (function(){
        const r=document.getElementById('tab_ringkasan'), l=document.getElementById('tab_lengkap');
        const pr=document.getElementById('panel_ringkasan'), pl=document.getElementById('panel_lengkap');
        const sr6=document.getElementById('sub_r6'), sr12=document.getElementById('sub_r12'), pr6=document.getElementById('panel_ring6'), pr12=document.getElementById('panel_ring12');
        const sl6=document.getElementById('sub_l6'), sl12=document.getElementById('sub_l12'), pl6=document.getElementById('panel_len6'), pl12=document.getElementById('panel_len12');
        function setMain(tab){ if(tab==='r'){ pr.style.display=''; pl.style.display='none'; r.className='px-3 py-1.5 rounded-md text-sm bg-sky-600 text-white'; l.className='px-3 py-1.5 rounded-md text-sm bg-white text-slate-700 border border-slate-300'; } else { pr.style.display='none'; pl.style.display=''; l.className='px-3 py-1.5 rounded-md text-sm bg-sky-600 text-white'; r.className='px-3 py-1.5 rounded-md text-sm bg-white text-slate-700 border border-slate-300'; } }
        function setRing(b){ if(b===6){ pr6.style.display=''; pr12.style.display='none'; sr6.className='px-3 py-1 rounded text-sm bg-sky-600 text-white'; sr12.className='px-3 py-1 rounded border border-slate-300 text-sm bg-white text-slate-700'; } else { pr6.style.display='none'; pr12.style.display=''; sr12.className='px-3 py-1 rounded text-sm bg-sky-600 text-white'; sr6.className='px-3 py-1 rounded border border-slate-300 text-sm bg-white text-slate-700'; } }
        function setLen(b){ if(b===6){ pl6.style.display=''; pl12.style.display='none'; sl6.className='px-3 py-1 rounded text-sm bg-sky-600 text-white'; sl12.className='px-3 py-1 rounded border border-slate-300 text-sm bg-white text-slate-700'; } else { pl6.style.display='none'; pl12.style.display=''; sl12.className='px-3 py-1 rounded text-sm bg-sky-600 text-white'; sl6.className='px-3 py-1 rounded border border-slate-300 text-sm bg-white text-slate-700'; } }
        if (r && l && pr && pl && sr6 && sr12 && pr6 && pr12 && sl6 && sl12 && pl6 && pl12){
          r.addEventListener('click', function(){ setMain('r'); });
          l.addEventListener('click', function(){ setMain('l'); });
          sr6.addEventListener('click', function(){ setRing(6); });
          sr12.addEventListener('click', function(){ setRing(12); });
          sl6.addEventListener('click', function(){ setLen(6); });
          sl12.addEventListener('click', function(){ setLen(12); });
          setMain('r'); setRing(12); setLen(12);
        }
      })();
    </script>
    <?php
  ?>
</div>

<?= view('layouts/dashboard_footer') ?>
