<?= view('layouts/dashboard_header', [
  'title' => 'Laporan - Indikator',
  'active' => 'laporan',
  'breadcrumb' => ['Admin','Laporan','Indikator']
]) ?>

<div class="bg-white rounded-2xl shadow p-6 mt-6">
  <?php
    $headers = [
      ['key' => 'no', 'label' => 'No', 'noSort' => true],
      ['key' => 'indikator', 'label' => 'Indikator'],
      ['key' => 'jumlah', 'label' => 'Jumlah Aksi', 'align' => 'right'],
    ];
    $backHref = base_url('admin/laporan/rencana').'?tahun='.urlencode((string)$tahun).'&status=true';
    echo '<div class="flex items-center gap-2 mb-1">'
        . '<a href="'.esc($backHref).'" class="inline-flex items-center justify-center w-8 h-8 rounded-md border border-slate-200 text-slate-600 hover:bg-slate-50" title="Kembali">'
        . '<svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"/><path d="M20 12H9"/></svg>'
        . '</a>'
        . '<h2 class="text-lg font-semibold">Indikator History '.esc($tahun).' — '.esc($rencana['kode'] ?? '').'</h2>'
        . '</div>';
    echo '<p class="text-sm text-slate-500 mb-4">Anda dapat memilih laporan berdasarkan field di bawah</p>';

    $tableRows = array_map(function($v){
      return [
        'indikator' => (string)($v['indikator'] ?? '-'),
        'jumlah' => (string)($v['jumlah'] ?? '0'),
      ];
    }, $rows ?? []);

    echo view('components/data-table', [
      'id' => 'dt_indikator',
      'headers' => $headers,
      'rows' => $tableRows,
      'pageSize' => 10,
    ]);
  ?>
</div>

<?= view('layouts/dashboard_footer') ?>
