<?= view('layouts/dashboard_header', [
  'title' => 'Pemantauan',
  'active' => 'pemantauanran',
  'breadcrumb' => ['Admin','Pemantauan']
]) ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <h2 class="text-lg font-semibold">Setting Pelaksana</h2>
    <p class="text-sm text-slate-500">Setting terlebih dahulu pelaksana agar dapat melakukan pemantauan RAN</p>

    <form method="get" class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-5">
      <div>
        <label class="block text-xs text-slate-600 mb-1">Level 1</label>
        <select class="w-full border rounded-lg px-3 py-2" name="level1_id" id="level1" required>
          <option value="">Pilih</option>
          <?php foreach (($level1 ?? []) as $val): $id=(int)($val['id']??0); $label=(string)($val['level1']??$val['nama']??$id); ?>
            <option value="<?= $id ?>" <?= $g1===(string)$id?'selected':''; ?>><?= esc($label) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label class="block text-xs text-slate-600 mb-1">Level 2</label>
        <select class="w-full border rounded-lg px-3 py-2" name="level2_id" id="level2" required>
          <?php if ($g2!==''): ?>
            <option selected value="<?= esc($g2) ?>">Terpilih</option>
          <?php else: ?>
            <option value="">Pilih</option>
          <?php endif; ?>
        </select>
      </div>
      <div>
        <label class="block text-xs text-slate-600 mb-1">Level 3</label>
        <select class="w-full border rounded-lg px-3 py-2" name="level3_id" id="level3">
          <?php if ($g3!==''): ?>
            <option selected value="<?= esc($g3) ?>">Terpilih</option>
          <?php else: ?>
            <option value="">Pilih</option>
          <?php endif; ?>
        </select>
      </div>
      <div class="md:col-span-3 flex items-center gap-2">
        <button class="inline-flex items-center gap-2 px-3 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">
          <i data-lucide="search" class="w-4 h-4"></i>
          <span>Set Pelaksana</span>
        </button>
        <a href="<?= site_url('admin/pemantauan') ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50">
          <i data-lucide="rotate-cw" class="w-4 h-4"></i>
          <span>Reset</span>
        </a>
      </div>
    </form>
  </div>

  <?php if (!empty($g1) && (!empty($g2) || !empty($g3))): ?>
    <div class="bg-white rounded-2xl shadow p-6 mt-6">
      <?php $items = $rencana ?? []; ?>
      <?php if (!empty($items)): ?>
        <div class="flex border-b text-sm">
          <?php foreach ($items as $idx => $val): ?>
            <button type="button" data-pane="r<?= $idx ?>" class="pm-tab px-4 py-2 border-b-2 <?= $idx===0?'border-indigo-600 text-indigo-600':'border-transparent text-slate-600' ?>">Rencana Aksi <?= $idx+1 ?></button>
          <?php endforeach; ?>
        </div>
        <?php $tahunCount = yearRencana(); ?>
        <?php foreach ($items as $idx => $val): ?>
          <div id="r<?= $idx ?>" class="pm-pane <?= $idx!==0?'hidden':'' ?> pt-4">
            <div class="space-y-3">
              <div class="flex gap-3"><div class="w-40 font-semibold">Monitor</div><div>: Inpres No 2 Tahun 2020 Tentang RAN P4GN 2020-2024</div></div>
              <div class="flex gap-3"><div class="w-40 font-semibold">Bidang</div><div>: <?= esc((string)($val['bidang'] ?? '-')) ?></div></div>
              <div class="flex gap-3"><div class="w-40 font-semibold">Program</div><div>: <?= esc((string)($val['program'] ?? '-')) ?></div></div>
              <div class="flex gap-3"><div class="w-40 font-semibold">Aksi Rencana</div><div>: <?= esc((string)($val['aksi'] ?? '-')) ?></div></div>
              <div class="flex gap-3"><div class="w-40 font-semibold">Indikator Keberhasilan</div>
                <div>:
                  <?php $inds = (array)($val['indikator'] ?? []); if (count($inds)<=1): ?>
                    <?= esc((string)($inds[0]['indikator'] ?? '-')) ?>
                  <?php else: foreach ($inds as $vv): ?>
                    <div>- <?= esc((string)($vv['indikator'] ?? '')) ?></div>
                  <?php endforeach; endif; ?>
                </div>
              </div>
            </div>

            <div class="mt-5">
              <div class="flex border-b text-sm">
                <?php for ($y=0; $y<= $tahunCount; $y++): ?>
                  <button type="button" data-year="r<?= $idx ?>-y<?= $y ?>" class="pm-year px-4 py-2 border-b-2 <?= $y===0?'border-indigo-600 text-indigo-600':'border-transparent text-slate-600' ?>"><?= '202'.$y ?></button>
                <?php endfor; ?>
              </div>
              <?php for ($y=0; $y<= $tahunCount; $y++): ?>
                <div id="r<?= $idx ?>-y<?= $y ?>" class="pm-year-pane <?= $y!==0?'hidden':'' ?> pt-4">
                  <?php $inds = (array)($val['indikator'] ?? []); ?>
                  <?php if (!empty($inds)): ?>
                    <?php foreach ($inds as $idk): ?>
                      <div class="border-t pt-4 mt-4">
                        <div class="flex gap-3"><div class="w-44 text-sm text-slate-600">Indikator Keberhasilan</div><div class="font-medium">: <?= esc((string)($idk['indikator'] ?? '')) ?></div></div>
                        <div class="flex gap-3 mt-1"><div class="w-44 text-sm text-slate-600">Ukuran Keberhasilan</div><div>: <?= esc(spesifikIndikator($y, (int)($idk['id'] ?? 0))) ?></div></div>
                        <div class="overflow-x-auto mt-3">
                          <table class="min-w-full table-auto border rounded-md overflow-hidden">
                            <thead class="bg-slate-50 text-xs">
                              <tr>
                                <th class="px-3 py-2 text-left">Periode</th>
                                <th class="px-3 py-2 text-left">Target Spesifik</th>
                                <th class="px-3 py-2 text-left">Capaian (%)</th>
                                <th class="px-3 py-2 text-left">Data Dukung</th>
                                <th class="px-3 py-2 text-center">Status</th>
                                <th class="px-3 py-2 text-left">Catatan Evaluator</th>
                              </tr>
                            </thead>
                            <tbody class="text-sm">
                              <?php foreach (($bulan ?? [6,12]) as $bln): ?>
                                <?php $result = getArrayKeberhasilan($y, $bln, (int)($idk['id'] ?? 0), (int)($val['pelaksana_id'] ?? 0)); ?>
                                <tr class="border-t">
                                  <td class="px-3 py-2">Bulan <?= $bln ?></td>
                                  <td class="px-3 py-2"><?= esc(getKeberhasilanSpesifikRencana($y, $bln, (int)($idk['id'] ?? 0), (int)($val['pelaksana_id'] ?? 0))) ?></td>
                                  <td class="px-3 py-2">
                                    <div class="w-48 bg-slate-100 rounded">
                                      <div class="h-3 bg-indigo-500 rounded" style="width: <?= (int)($result['progress'] ?? 0) ?>%"></div>
                                    </div>
                                  </td>
                                  <td class="px-3 py-2"><?= statusFormAdmin($result['id'] ?? null, (int)($val['pelaksana_id'] ?? 0)) ?></td>
                                  <td class="px-3 py-2 text-center"><?= evaluatorStatus($result['status_eval'] ?? 0) ?></td>
                                  <td class="px-3 py-2">
                                    <?php
                                      $catatans = [];
                                      if (!empty($result['id'])) {
                                        try { $catatans = db_connect()->table('catatan')->where('keberhasilan_id', (int)$result['id'])->get()->getResultArray(); } catch (\Throwable $e) { $catatans = []; }
                                      }
                                    ?>
                                    <ul class="list-disc pl-5">
                                      <?php if (!empty($result['catatan_eval'])): ?>
                                        <li><?= esc((string)$result['catatan_eval']) ?></li>
                                      <?php endif; ?>
                                      <?php foreach ($catatans as $catatan): ?>
                                        <li><?= esc((string)($catatan['catatan_eval'] ?? '')) ?></li>
                                      <?php endforeach; ?>
                                    </ul>
                                  </td>
                                </tr>
                              <?php endforeach; ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <div class="text-center text-slate-500 py-10">Tidak ada target spesifik</div>
                  <?php endif; ?>
                </div>
              <?php endfor; ?>
            </div>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="text-center text-slate-500 py-10">Tidak ada data rencana</div>
      <?php endif; ?>
    </div>

    <script>
      (function(){
        function activateTabs(){
          document.querySelectorAll('.pm-tab').forEach(function(btn){
            btn.addEventListener('click', function(){
              var id = this.getAttribute('data-pane');
              if (!id) return;
              document.querySelectorAll('.pm-pane').forEach(function(p){ p.classList.add('hidden'); });
              document.getElementById(id).classList.remove('hidden');
              document.querySelectorAll('.pm-tab').forEach(function(b){ b.classList.remove('border-indigo-600','text-indigo-600'); b.classList.add('border-transparent','text-slate-600'); });
              this.classList.add('border-indigo-600','text-indigo-600'); this.classList.remove('border-transparent','text-slate-600');
            });
          });
          document.querySelectorAll('.pm-year').forEach(function(btn){
            btn.addEventListener('click', function(){
              var id = this.getAttribute('data-year');
              if (!id) return;
              var group = id.split('-')[0];
              document.querySelectorAll('[id^="'+group+'-y"]').forEach(function(p){ p.classList.add('hidden'); });
              document.getElementById(id).classList.remove('hidden');
              var parent = this.parentElement; if (!parent) return;
              parent.querySelectorAll('.pm-year').forEach(function(b){ b.classList.remove('border-indigo-600','text-indigo-600'); b.classList.add('border-transparent','text-slate-600'); });
              this.classList.add('border-indigo-600','text-indigo-600'); this.classList.remove('border-transparent','text-slate-600');
            });
          });
          try { if (window.lucide) window.lucide.createIcons(); } catch(e) {}
        }
        activateTabs();
      })();
    </script>
  <?php endif; ?>

<?= view('layouts/dashboard_footer') ?>
