<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    .glass { backdrop-filter: blur(12px); background: rgba(14, 12, 22, 0.5); }
    .neon { background: radial-gradient(1200px 600px at 70% 40%, rgba(99,102,241,.35), rgba(236,72,153,.25), rgba(0,0,0,0)); }
  </style>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body class="min-h-screen text-white bg-gradient-to-r from-sky-500 via-indigo-500 to-sky-500" style="font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell, Noto Sans, Helvetica Neue, Arial, \"Apple Color Emoji\", \"Segoe UI Emoji\";">
  <div class="relative min-h-screen flex items-center justify-center p-4">
    <div class="absolute inset-0 neon"></div>

    <div class="relative w-full max-w-6xl grid grid-cols-1 lg:grid-cols-2 rounded-3xl overflow-hidden shadow-2xl ring-1 ring-white/10">
      <!-- Left: Login Panel -->
      <div class="glass px-8 py-10 lg:px-12 lg:py-14">
        <div class="flex items-center gap-3 mb-10">
          <div class="w-10 h-10 rounded-xl bg-indigo-500/20 grid place-items-center text-indigo-300">
            <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M17.982 18.725A7.488 7.488 0 0012 15.75a7.488 7.488 0 00-5.982 2.975m11.964 0a9 9 0 10-11.964 0m11.964 0A8.966 8.966 0 0112 21a8.966 8.966 0 01-5.982-2.275M15 9.75a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
          </div>
          <div>
            <div class="text-sm uppercase tracking-widest text-white/60">Welcome back</div>
            <div class="text-l font-semibold">Masuk ke Akun</div>
          </div>
        </div>

        <?php if (session()->getFlashdata('error')): ?>
          <div class="mb-5 bg-red-500/10 text-red-200 px-4 py-2 rounded-lg border border-red-500/30"><?= esc(session()->getFlashdata('error')) ?></div>
        <?php endif; ?>

        <form method="post" action="<?= site_url('auth/attempt') ?>" class="space-y-5">
          <?= csrf_field() ?>

          <div>
            <label class="block text-xs font-medium text-white/70 mb-2">Username</label>
            <div class="relative">
              <span class="absolute inset-y-0 left-3 flex items-center text-white/50">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.5 20.118a7.5 7.5 0 0115 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.5-1.632z"/></svg>
              </span>
              <input name="username" type="text" required class="w-full bg-white/5 border border-white/10 rounded-xl py-3 pl-11 pr-4 text-white placeholder-white/40 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent" placeholder="Username">
            </div>
          </div>

          <div>
            <label class="block text-xs font-medium text-white/70 mb-2">Password</label>
            <div class="relative">
              <span class="absolute inset-y-0 left-3 flex items-center text-white/50">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M16.5 10.5V6.75a4.5 4.5 0 10-9 0v3.75M5.25 10.5h13.5v9.75H5.25V10.5z"/></svg>
              </span>
              <input name="password" type="password" required class="w-full bg-white/5 border border-white/10 rounded-xl py-3 pl-11 pr-4 text-white placeholder-white/40 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent" placeholder="••••••••">
            </div>
          </div>

          <button type="submit" class="w-full inline-flex justify-center items-center rounded-xl bg-indigo-600 hover:bg-indigo-500 text-white py-3 font-semibold tracking-wide shadow-lg shadow-indigo-900/30 transition">
            LOGIN
          </button>
        </form>
      </div>

      <!-- Right: Welcome / Hero Panel -->
      <div class="relative hidden lg:block" style="background-image: url('<?= base_url('images/bg.jpg') ?>'); background-size: cover; background-position: center;">
        <div class="absolute inset-0 bg-black/50"></div>

        <div class="relative h-full w-full px-12 py-14 flex flex-col justify-between">
          <div class="mt-10 text-center">
            <div class="text-xl md:text-xl xl:text-xl font-extrabold tracking-wide leading-tight uppercase text-white/70">
              Sistem Pemantauan dan Evaluasi<br/>
              Implementasi Inpres No.2 Tahun 2020<br/>
              Tentang RAN P4GN
            </div>
            <img src="<?= base_url('images/lg.png') ?>" alt="Logo" class="mt-12 h-16 w-auto mx-auto select-none pointer-events-none" />
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
