<?php
// Simple filter bar component
// Props: $searchPlaceholder, $actions (array of [href,label])
$searchPlaceholder = $searchPlaceholder ?? 'Cari...';
$actions = $actions ?? [];
?>
<div class="flex flex-col sm:flex-row items-stretch sm:items-center gap-3 mb-4">
  <div class="flex-1">
    <input type="text" placeholder="<?= esc($searchPlaceholder) ?>" class="w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500" />
  </div>
  <div class="flex items-center gap-2">
    <?php foreach ($actions as $a): ?>
      <a href="<?= esc($a['href'] ?? '#') ?>" class="inline-flex items-center px-3 py-2 rounded bg-indigo-600 text-white hover:bg-indigo-700 text-sm"><?= esc($a['label'] ?? 'Action') ?></a>
    <?php endforeach; ?>
  </div>
</div>
