<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Dashboard') ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
  <script src="https://unpkg.com/lucide@latest"></script>
  <style>
    body { font-family: Inter, ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell, Noto Sans, Helvetica Neue, Arial; }
    .card { @apply bg-white rounded-2xl shadow border border-slate-200; }
  </style>
</head>
<body class="min-h-screen bg-slate-50 text-slate-800">
  <header class="sticky top-0 z-40 bg-gradient-to-r from-sky-500 via-indigo-500 to-sky-500 backdrop-blur supports-backdrop-blur:bg-white/60 border-b border-indigo-100 shadow-sm">
    <div class="pointer-events-none absolute inset-x-0 -top-1 h-1 bg-gradient-to-r from-indigo-600 via-indigo-500 to-sky-400 opacity-90"></div>
    <?php
      // session data for user dropdown
      $s = session();
      // Prefer a controller-provided variable if set, else resolve from multiple common keys
      $userName = isset($userName) && $userName !== '' ? (string)$userName : '';
      if ($userName === '') {
        $userName = (string)($s->get('nama')
          ?? $s->get('username')
          ?? $s->get('name')
          ?? $s->get('fullname')
          ?? $s->get('email')
          ?? '');
      }
      $userName = trim($userName);
      if ($userName === '') { $userName = 'User'; }
      $roleStr = strtolower((string)($s->get('role') ?? 'user'));
      $roleHead = explode(' ', $roleStr)[0] ?? 'user';
      $profileUrl = base_url(($roleHead ?: 'user') . '/profile');
    ?>
    <!-- Row 1: Title + user dropdown + mobile toggle -->
    <div class="relative z-10 h-14 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex items-center justify-between gap-4 text-white">
      <a href="<?= base_url('/') ?>" class="inline-flex items-center gap-2 text-white font-extrabold tracking-wide whitespace-nowrap">
        <img src="<?= base_url('images/Logo_BNN.svg') ?>" alt="Logo" class="h-7 w-auto"/>
        <span>INPRES<span class="text-white/90">NO.2 TH.2020</span></span>
      </a>
      <div class="flex items-center gap-3">
        <div class="relative">
          <button id="userMenuBtn" class="inline-flex items-center gap-2 rounded-lg px-3 py-2 text-white hover:bg-white/10" title="<?= esc($userName ?: 'User') ?>">
            <span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-indigo-600 text-white text-xs font-semibold">
              <?= strtoupper(substr($userName,0,1)) ?>
            </span>
            <span class="block text-xs font-medium max-w-[12rem] truncate"><?= esc($userName ?: 'User') ?></span>
            <svg class="w-4 h-4 text-white/70" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M6 9l6 6 6-6"/></svg>
          </button>
          <div id="userDropdown" class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg border border-slate-200 py-1 hidden z-50">
            <a href="<?= $profileUrl ?>" class="flex items-center gap-2 px-3 py-2 text-sm text-slate-700 hover:bg-slate-50">
              <i data-lucide="settings" class="w-4 h-4"></i>
              <span>Account Settings</span>
            </a>
            <a href="<?= base_url('logout') ?>" class="flex items-center gap-2 px-3 py-2 text-sm text-red-600 hover:bg-red-50">
              <i data-lucide="log-out" class="w-4 h-4"></i>
              <span>Logout</span>
            </a>
          </div>
        </div>
        <button id="navToggle" class="md:hidden inline-flex items-center justify-center rounded-lg border border-white/30 px-3 py-2 text-white" aria-label="Toggle Menu">
          <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M3 6h18M3 12h18M3 18h18"/></svg>
        </button>
      </div>
    </div>

    <?php
      // Inline top menu (same names as before via Config\Menu)
      /** @var array $menuItems */
      $menuItems = \Config\Menu::forCurrentUser();
      // Lucide icon mapping per old_app labels
      $iconMap = [
        'dashboard' => 'layout-dashboard',
        'profile' => 'user',
        'dokumentasi' => 'book-text',
        'wilayah' => 'map',
        'master' => 'settings-2',
        'level' => 'layers-2',
        'groupwilayah' => 'users',
        'role' => 'shield',
        'satuan' => 'boxes',
        'managementuser' => 'users',
        'intruksipresiden' => 'scroll-text',
        'pemantauanran' => 'activity',
        'laporan' => 'bar-chart-3',
        'setting' => 'sliders-horizontal',
        'periode' => 'calendar',
        'capaiankeluaran' => 'target',
        'rangking' => 'medal',
        'default' => 'circle-dot',
      ];
      $labelToKey = function(string $label) {
        $k = strtolower($label);
        $k = preg_replace('/[^a-z0-9]+/','', $k);
        return $k;
      };
      $resolveIcon = function(array $item) use ($iconMap, $labelToKey) {
        $key = $labelToKey($item['label'] ?? '');
        foreach ($iconMap as $k => $p) {
          if ($k !== 'default' && strpos($key, $k) !== false) return $p;
        }
        return $iconMap['default'];
      };
    ?>

    <!-- Row 2: Menu (desktop) -->
    <div class="relative z-10 hidden md:block border-t border-white/20">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <nav class="overflow-visible">
          <ul class="flex flex-wrap items-center gap-x-5 gap-y-1 py-2 text-xs">
            <?php foreach ($menuItems as $idx => $item): $icon = $resolveIcon($item); $mid = 'ddm'.($idx+1); ?>
              <?php if (!empty($item['children'])): ?>
                <li class="relative">
                  <button type="button" class="inline-flex items-center gap-2 text-white/80 hover:text-white font-medium" data-dd-trigger="<?= $mid ?>">
                    <i data-lucide="<?= esc($icon) ?>" class="w-4 h-4"></i>
                    <span class="text-xs"><?= esc($item['label']) ?></span>
                    <i data-lucide="chevron-down" class="w-4 h-4"></i>
                  </button>
                  <div id="<?= $mid ?>" class="absolute left-0 top-full bg-white shadow-md rounded-md mt-2 p-2 z-50 min-w-[12rem] border border-slate-200 hidden">
                    <?php foreach ($item['children'] as $child): $cIcon = $resolveIcon($child); ?>
                      <a class="flex items-center gap-2 px-3 py-1.5 rounded hover:bg-slate-50 text-slate-700" href="<?= esc($child['href']) ?>">
                        <i data-lucide="<?= esc($cIcon) ?>" class="w-4 h-4"></i>
                        <span class="text-xs"><?= esc($child['label']) ?></span>
                      </a>
                    <?php endforeach; ?>
                  </div>
                </li>
              <?php else: ?>
                <li>
                  <a class="inline-flex items-center gap-2 text-white/80 hover:text-white font-medium" href="<?= esc($item['href']) ?>">
                    <i data-lucide="<?= esc($icon) ?>" class="w-4 h-4"></i>
                    <span class="text-xs"><?= esc($item['label']) ?></span>
                  </a>
                </li>
              <?php endif; ?>
            <?php endforeach; ?>
          </ul>
        </nav>
      </div>
    </div>

    <!-- Row 2: Mobile Menu -->
    <div id="mobileMenu" class="md:hidden hidden border-t border-slate-200 bg-white">
      <div class="max-w-7xl mx-auto px-4 py-2">
        <ul class="space-y-1 text-sm">
          <?php foreach ($menuItems as $item): $icon = $resolveIcon($item); ?>
            <?php if (!empty($item['children'])): ?>
              <li>
                <div class="px-2 py-2 text-slate-700 font-medium flex items-center gap-2">
                  <i data-lucide="<?= esc($icon) ?>" class="w-4 h-4"></i>
                  <span><?= esc($item['label']) ?></span>
                </div>
                <div class="pl-6 pb-2 space-y-1">
                  <?php foreach ($item['children'] as $child): $cIcon = $resolveIcon($child); ?>
                    <a class="flex items-center gap-2 px-2 py-1.5 rounded hover:bg-slate-50 text-slate-700" href="<?= esc($child['href']) ?>">
                      <i data-lucide="<?= esc($cIcon) ?>" class="w-4 h-4"></i>
                      <span class="text-xs"><?= esc($child['label']) ?></span>
                    </a>
                  <?php endforeach; ?>
                </div>
              </li>
            <?php else: ?>
              <li>
                <a class="flex items-center gap-2 px-2 py-2 rounded hover:bg-slate-50 text-slate-700" href="<?= esc($item['href']) ?>">
                  <i data-lucide="<?= esc($icon) ?>" class="w-4 h-4"></i>
                  <span class="text-xs"><?= esc($item['label']) ?></span>
                </a>
              </li>
            <?php endif; ?>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>
    <script>
      (function(){
        var btn=document.getElementById('navToggle');
        var menu=document.getElementById('mobileMenu');
        if(btn&&menu){btn.addEventListener('click',function(){menu.classList.toggle('hidden');});}
        var ubtn=document.getElementById('userMenuBtn');
        var uddl=document.getElementById('userDropdown');
        if(ubtn&&uddl){ubtn.addEventListener('click',function(){uddl.classList.toggle('hidden');});
          document.addEventListener('click',function(e){if(!ubtn.contains(e.target)&&!uddl.contains(e.target)){uddl.classList.add('hidden');}});
        }

        // Desktop dropdowns: click to toggle so it doesn't disappear when moving cursor
        document.querySelectorAll('[data-dd-trigger]').forEach(function(t){
          var id=t.getAttribute('data-dd-trigger');
          var panel=document.getElementById(id);
          if(!panel) return;
          t.addEventListener('click', function(e){
            e.stopPropagation();
            // close others
            document.querySelectorAll('[id^="ddm"]').forEach(function(p){ if(p!==panel){ p.classList.add('hidden'); }});
            panel.classList.toggle('hidden');
          });
          // keep open while hovering panel
          panel.addEventListener('mouseenter', function(){ panel.dataset.hover='1'; });
          panel.addEventListener('mouseleave', function(){ panel.dataset.hover=''; panel.classList.add('hidden'); });
        });
        document.addEventListener('click', function(){
          document.querySelectorAll('[id^="ddm"]').forEach(function(p){ p.classList.add('hidden'); });
        });
        // Initialize Lucide icons
        if(window.lucide){ window.lucide.createIcons(); }
      })();
    </script>
  </header>
  <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">

    <!-- Toast Container -->
    <div id="toastContainer" class="fixed inset-0 z-[100] pointer-events-none">
      <div id="toast" class="absolute top-4 right-4 w-[22rem] p-3 bg-white rounded-lg shadow-lg border hidden transition-all duration-200 ease-out transform translate-y-2 opacity-0">
        <div class="flex items-start gap-3">
          <div id="toastIcon" class="shrink-0 p-2 rounded-full bg-emerald-100 text-emerald-600">
            <i data-lucide="check-circle" class="w-5 h-5"></i>
          </div>
          <div class="flex-1">
            <div id="toastTitle" class="text-xs font-semibold text-slate-500">Notifikasi</div>
            <div id="toastBody" class="text-sm text-slate-800 leading-snug"></div>
          </div>
        </div>
      </div>
    </div>

    <!-- Modal Container -->
    <div id="appModal" class="fixed inset-0 z-[100] hidden">
      <div class="absolute inset-0 bg-black/40" data-modal-close></div>
      <div class="absolute inset-0 flex items-start justify-center overflow-auto p-4">
        <div class="mt-10 w-full max-w-2xl bg-white rounded-xl shadow-xl border border-slate-200">
          <div class="flex items-center justify-between px-4 py-3 border-b">
            <div class="text-sm font-semibold text-slate-700" id="appModalTitle">Detail</div>
            <button class="p-1 rounded hover:bg-slate-100" data-modal-close aria-label="Close">
              <i data-lucide="x" class="w-5 h-5"></i>
            </button>
          </div>
          <div id="appModalBody" class="p-4"></div>
        </div>
      </div>
    </div>

    <script>
      (function(){
        var modal = document.getElementById('appModal');
        var body = document.getElementById('appModalBody');
        var title = document.getElementById('appModalTitle');
        var toastEl = document.getElementById('toast');
        var toastBody = document.getElementById('toastBody');
        var toastIcon = document.getElementById('toastIcon');
        var toastTitle = document.getElementById('toastTitle');
        function showToast(message, type){
          if(!toastEl||!toastBody||!toastIcon||!toastTitle) return;
          var styles = {
            success: { box: 'border-emerald-200 bg-emerald-50', iconWrap: 'bg-emerald-100 text-emerald-600', icon: 'check-circle', title: 'Sukses' },
            error:   { box: 'border-rose-200 bg-rose-50',       iconWrap: 'bg-rose-100 text-rose-600',       icon: 'x-circle',     title: 'Gagal' },
            info:    { box: 'border-sky-200 bg-sky-50',         iconWrap: 'bg-sky-100 text-sky-600',         icon: 'info',         title: 'Info' },
            warn:    { box: 'border-amber-200 bg-amber-50',     iconWrap: 'bg-amber-100 text-amber-700',     icon: 'alert-triangle', title: 'Peringatan' }
          };
          var s = styles[type] || styles.success;
          // container styles
          toastEl.className = 'absolute top-4 right-4 w-[22rem] p-3 rounded-lg shadow-lg border pointer-events-auto transition-all duration-200 ease-out transform '+s.box;
          // icon wrap
          toastIcon.className = 'shrink-0 p-2 rounded-full '+s.iconWrap;
          toastIcon.innerHTML = '<i data-lucide="'+s.icon+'" class="w-5 h-5"></i>';
          toastTitle.textContent = s.title;
          toastBody.textContent = message || '';
          // animate in
          toastEl.classList.remove('hidden');
          toastEl.classList.remove('translate-y-2','opacity-0');
          try{ if(window.lucide){ window.lucide.createIcons(); } }catch(e){}
          // auto hide
          clearTimeout(window.__toastTimer);
          window.__toastTimer = setTimeout(function(){
            toastEl.classList.add('translate-y-2','opacity-0');
            setTimeout(function(){ toastEl.classList.add('hidden'); }, 200);
          }, 2600);
        }
        // Display queued toast from previous navigation (set via localStorage)
        try {
          var queued = localStorage.getItem('toast');
          if (queued) {
            var obj = JSON.parse(queued);
            showToast(obj.m||'', obj.t||'success');
            localStorage.removeItem('toast');
          }
        } catch(e) {}
        // Also show PHP flashdata if present
        try {
          var phpSuccess = <?php echo json_encode((string)(session()->getFlashdata('success') ?? '')); ?>;
          var phpError = <?php echo json_encode((string)(session()->getFlashdata('error') ?? '')); ?>;
          if (phpSuccess) { showToast(phpSuccess, 'success'); }
          else if (phpError) { showToast(phpError, 'error'); }
        } catch(e) {}
        function openModal(t){ modal.classList.remove('hidden'); title.textContent = t || 'Detail'; try{ if(window.lucide){ window.lucide.createIcons(); } }catch(e){} }
        function closeModal(){ modal.classList.add('hidden'); body.innerHTML=''; }
        // Close when clicking overlay or any element (or its children) with data-modal-close
        modal.addEventListener('click', function(e){ if(e.target.closest('[data-modal-close]')) closeModal(); });
        // Bind click to all close triggers inside modal (button X, overlay)
        function bindCloseButtons(){
          var btns = modal.querySelectorAll('[data-modal-close]');
          btns.forEach(function(b){ b.addEventListener('click', function(){ closeModal(); }); });
        }
        bindCloseButtons();
        // Close on Escape key
        document.addEventListener('keydown', function(e){ if(!modal.classList.contains('hidden') && e.key === 'Escape'){ closeModal(); } });

        function initTomSelects(){ /* removed to comply with CSP */ }

        function fetchIntoModal(url, label){
          title.textContent = label || 'Detail';
          body.innerHTML = '<div class="p-3 text-slate-500 text-sm">Memuat...</div>';
          // Ensure modal is visible
          if (modal.classList.contains('hidden')) { modal.classList.remove('hidden'); }
          fetch(url, { headers: { 'X-Requested-With':'XMLHttpRequest' }})
            .then(function(r){ return r.text(); })
            .then(function(html){
              body.innerHTML = html;
              if (window.lucide) { window.lucide.createIcons(); }
            })
            .catch(function(){
              body.innerHTML = '<div class="p-3 text-rose-600 text-sm">Gagal memuat konten</div>';
            });
        }

        document.addEventListener('click', function(e){
          var a = e.target.closest('a[data-modal]');
          if(a){ e.preventDefault(); var lbl = a.getAttribute('data-modal')||a.getAttribute('title')||a.textContent||'Detail'; fetchIntoModal(a.href, lbl.trim()); }
        });

        // No Tom Select init (CSP)

        // Delegated change listeners for Pelaksana dependent selects inside modal
        document.addEventListener('change', function(e){
          var t = e.target;
          if (!t) return;
          // Helper to rebuild options
          function setOpts(sel, items, labelKey){ if(!sel) return; sel.innerHTML=''; var o=document.createElement('option'); o.value=''; o.textContent='Pilih'; sel.appendChild(o); (items||[]).forEach(function(it){ var op=document.createElement('option'); op.value=it.id; op.textContent=it[labelKey]; sel.appendChild(op); }); }
          if (t.id === 'level1') {
            var wrap = t.closest('form');
            var l2 = wrap ? wrap.querySelector('#level2') : document.getElementById('level2');
            var l3 = wrap ? wrap.querySelector('#level3') : document.getElementById('level3');
            setOpts(l2, [], 'level2'); setOpts(l3, [], 'level3');
            var id = t.value; if(!id) return;
            fetch('<?= base_url('admin/rencana/pelaksana/options/level2') ?>?level1_id='+encodeURIComponent(id), { headers: { 'X-Requested-With':'XMLHttpRequest' }})
              .then(function(r){ return r.json(); })
              .then(function(d){ setOpts(l2, (d&&d.items)||[], 'level2'); });
          }
          if (t.id === 'level2') {
            var wrap2 = t.closest('form');
            var l3b = wrap2 ? wrap2.querySelector('#level3') : document.getElementById('level3');
            setOpts(l3b, [], 'level3');
            var id2 = t.value; if(!id2) return;
            fetch('<?= base_url('admin/rencana/pelaksana/options/level3') ?>?level2_id='+encodeURIComponent(id2), { headers: { 'X-Requested-With':'XMLHttpRequest' }})
              .then(function(r){ return r.json(); })
              .then(function(d){ setOpts(l3b, (d&&d.items)||[], 'level3'); });
          }
        });

        // Intercept generic form submissions inside modal (without data-confirm) to avoid full-page loads
        document.addEventListener('submit', function(e){
          var f = e.target;
          if (!(f instanceof HTMLFormElement)) return;
          // Only handle forms inside the modal body
          if (!body.contains(f)) return;
          // Skip confirm-handled forms
          if (f.hasAttribute('data-confirm')) return;
          e.preventDefault();
          var fd = new FormData(f);
          fetch(f.action, { method: (f.method||'POST').toUpperCase(), body: fd, headers: { 'X-Requested-With':'XMLHttpRequest' }})
            .then(function(r){ if(r.redirected){ window.location.href = r.url; return null; } return r.text(); })
            .then(function(t){ if(t===null) return; closeModal(); window.location.reload(); })
            .catch(function(){ closeModal(); window.location.reload(); });
        });

        // In-app confirm dialog for delete forms
        function showConfirm(message, onConfirm, confirmLabel){
          title.textContent = 'Konfirmasi';
          body.innerHTML = '<div class="p-1"'
            +'<div class="flex items-start gap-3">'
            +'<div class="shrink-0 p-2 rounded-full bg-rose-100 text-rose-600"><i data-lucide="alert-triangle" class="w-5 h-5"></i></div>'
            +'<div class="text-sm text-slate-700 leading-relaxed break-words whitespace-normal">'+(message||'Yakin melakukan aksi ini?')+'</div>'
            +'</div>'
            +'<div class="mt-6 flex justify-end gap-2">'
            +'<button class="px-3 py-2 rounded-lg border" data-modal-close>Batal</button>'
            +'<button id="appModalConfirmBtn" class="px-3 py-2 rounded-lg bg-rose-600 text-white hover:bg-rose-700">'+(confirmLabel||'Ya')+'</button>'
            +'</div>'
            +'</div>';
          openModal('Konfirmasi');
          try{ if(window.lucide){ window.lucide.createIcons(); } }catch(e){}
          bindCloseButtons();
          var ok = document.getElementById('appModalConfirmBtn');
          if(ok && typeof onConfirm === 'function'){
            ok.addEventListener('click', function(){ onConfirm(); });
          }
        }

        document.addEventListener('click', function(e){
          var submitBtn = e.target.closest('form[data-confirm] button[type="submit"]');
          if(submitBtn){
            var form = submitBtn.closest('form[data-confirm]');
            if(!form) return;
            e.preventDefault();
            var msg = form.getAttribute('data-confirm') || 'Yakin hapus data ini?';
            var act = form.action || '';
            var cLabel = form.getAttribute('data-confirm-label') || (act.indexOf('/delete/')>-1 ? 'Hapus' : 'Ya');
            showConfirm(msg, function(){
              var fd = new FormData(form);
              fetch(form.action, { method:'POST', body: fd, headers: { 'X-Requested-With':'XMLHttpRequest' }})
                .then(function(r){ if(r.redirected){ try { localStorage.setItem('toast', JSON.stringify({t:'success', m: (act.indexOf('/delete/')>-1?'Berhasil dihapus':'Berhasil')})); } catch(e) {} window.location.href = r.url; return null; } return r.text(); })
                .then(function(t){ try { localStorage.setItem('toast', JSON.stringify({t:'success', m: (act.indexOf('/delete/')>-1?'Berhasil dihapus':'Berhasil')})); } catch(e) {} closeModal(); window.location.reload(); })
                .catch(function(){ try { localStorage.setItem('toast', JSON.stringify({t:'error', m:(act.indexOf('/delete/')>-1?'Gagal menghapus. Coba lagi.':'Terjadi kesalahan. Coba lagi.')})); } catch(e) {} closeModal(); window.location.reload(); });
            }, cLabel);
          }
        });
      })();
    </script>
