<?php
namespace App\Controllers;

use App\Config\Custom;
use CodeIgniter\HTTP\Files\UploadedFile;

class UploadController extends BaseController
{
    public function form()
    {
        $data = [
            'maxSize' => Custom::uploadMaxSize(),
            'allowedExt' => Custom::allowedExt(),
        ];
        return view('upload/form', $data);
    }

    public function store()
    {
        $file = $this->request->getFile('file');
        if (!$file || !$file->isValid()) {
            return redirect()->back()->with('error', 'File tidak valid');
        }

        $max = Custom::uploadMaxSize();
        if ($file->getSize() > $max) {
            return redirect()->back()->with('error', 'File melebihi ukuran maksimum ' . number_format($max / 1048576, 2) . ' MB');
        }

        $allowed = array_map('strtolower', Custom::allowedExt());
        $ext = strtolower($file->getExtension());
        if (!in_array($ext, $allowed, true)) {
            return redirect()->back()->with('error', 'Ekstensi tidak diizinkan: ' . $ext);
        }

        $targetDir = Custom::uploadPath();
        if (!is_dir($targetDir)) {
            @mkdir($targetDir, 0775, true);
        }
        if (!is_dir($targetDir) || !is_writable($targetDir)) {
            return redirect()->back()->with('error', 'Folder upload tidak dapat ditulis: ' . $targetDir);
        }

        // Safe filename
        $safeName = $file->getRandomName();
        try {
            $file->move($targetDir, $safeName, true);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', 'Gagal menyimpan file: ' . $e->getMessage());
        }

        session()->setFlashdata('success', 'Upload berhasil: ' . $safeName);
        return redirect()->to(base_url('upload'));
    }
}
