<?php
if (! function_exists('listPeriode')) {
    function listPeriode(): array
    {
        return [
            '2020_6','2020_12','2021_6','2021_12','2022_6','2022_12','2023_6','2023_12','2024_6','2024_12'
        ];
    }
}
if (! function_exists('listRencana')) {
    function listRencana(): array
    {
        try { return db_connect()->table('rencana')->get()->getResultArray(); } catch (\Throwable $e) { return []; }
    }
}
if (! function_exists('listPelaksana')) {
    function listPelaksana(): array
    {
        try { return db_connect()->table('level1')->get()->getResultArray(); } catch (\Throwable $e) { return []; }
    }
}
if (! function_exists('mergeCapaian')) {
    function mergeCapaian(array $data): array
    {
        $groups = [];
        foreach ($data as $item) {
            $key = $item['level2_id'] ?? null;
            if ($key === null) continue;
            if (!array_key_exists($key, $groups)) {
                $groups[$key] = $item;
            } else {
                $groups[$key]['total_output'] = ($groups[$key]['total_output'] ?? 0) + ($item['total_output'] ?? 0);
            }
        }
        usort($groups, function($a,$b){ return ($a['total_output'] ?? 0) <=> ($b['total_output'] ?? 0); });
        return array_reverse(array_values($groups));
    }
}
