<?php
namespace App\Models;

class ProfileModel
{
    public function getById(int $id): ?array
    {
        try {
            $db = db_connect();
            $row = $db->table('user')->where('id', $id)->get()->getRowArray();
            return $row ?: null;
        } catch (\Throwable $e) {
            return null;
        }
    }

    public function updateWithPasswordCheck(int $id, array $data, ?string $oldPassword, ?string $newPassword): bool
    {
        try {
            $db = db_connect();
            $current = $db->table('user')->where('id', $id)->get()->getRowArray();
            if (!$current) return false;
            if ($oldPassword === null || $oldPassword === '') return false;
            if (!password_verify($oldPassword, (string)($current['password'] ?? ''))) return false;
            if ($newPassword !== null && $newPassword !== '') {
                $data['password'] = password_hash($newPassword, PASSWORD_DEFAULT);
            }
            $db->table('user')->where('id', $id)->update($data);
            return $db->affectedRows() >= 0;
        } catch (\Throwable $e) {
            return false;
        }
    }
}
