<?php
namespace App\Models;

use CodeIgniter\Model;

class UserAuthModel extends Model
{
    protected $table      = 'user';
    protected $primaryKey = 'id';
    protected $returnType = 'array';

    public function findByUsername(string $username): ?array
    {
        $db = $this->db;
        $builder = $db->table('user')
            ->select('user.*, role.role, level1.level1, level2.level2, level3.level3, user.group_wilayah_id')
            ->join('role', 'role.id = user.role_id', 'left')
            ->join('level1', 'level1.id = user.level1_id', 'left')
            ->join('level2', 'level2.id = user.level2_id', 'left')
            ->join('level3', 'level3.id = user.level3_id', 'left')
            ->where('username', $username)
            ->limit(1);
        $row = $builder->get()->getRowArray();
        return $row ?: null;
    }
}
